/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.pdfcleanup;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.io.RandomAccessSourceFactory;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PRIndirectReference;
import com.itextpdf.text.pdf.PRTokeniser;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfBoolean;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.PdfStream;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.RandomAccessFileOrArray;
import com.itextpdf.text.pdf.parser.ContentByteUtils;
import com.itextpdf.text.pdf.parser.PdfContentStreamProcessor;
import com.itextpdf.text.pdf.parser.RenderListener;
import com.itextpdf.text.pdf.pdfcleanup.PdfCleanUpContentOperator;
import com.itextpdf.text.pdf.pdfcleanup.PdfCleanUpLocation;
import com.itextpdf.text.pdf.pdfcleanup.PdfCleanUpRegionFilter;
import com.itextpdf.text.pdf.pdfcleanup.PdfCleanUpRenderListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PdfCleanUpProcessor {
    public static double floatMultiplier = Math.pow(10.0, 14.0);
    public static boolean fillCleanedArea = true;
    public static double arcTolerance = 0.0025;
    private static final String XOBJ_NAME_PREFIX = "Fm";
    private static final String STROKE_COLOR = "StrokeColor";
    private static final String FILL_COLOR = "FillColor";
    private int currentXObjNum = 0;
    private PdfStamper pdfStamper;
    private Map<Integer, List<PdfCleanUpLocation>> pdfCleanUpLocations;
    private Map<Integer, Set<String>> redactAnnotIndirRefs;
    private Map<Integer, List<Rectangle>> clippingRects;

    public PdfCleanUpProcessor(List<PdfCleanUpLocation> pdfCleanUpLocations, PdfStamper pdfStamper) {
        this.pdfCleanUpLocations = this.organizeLocationsByPage(pdfCleanUpLocations);
        this.pdfStamper = pdfStamper;
    }

    public PdfCleanUpProcessor(PdfStamper pdfStamper) {
        this.redactAnnotIndirRefs = new HashMap<Integer, Set<String>>();
        this.clippingRects = new HashMap<Integer, List<Rectangle>>();
        this.pdfStamper = pdfStamper;
        this.extractLocationsFromRedactAnnots();
    }

    public void cleanUp() throws IOException, DocumentException {
        for (Map.Entry<Integer, List<PdfCleanUpLocation>> entry : this.pdfCleanUpLocations.entrySet()) {
            this.cleanUpPage(entry.getKey(), entry.getValue());
        }
        this.pdfStamper.getReader().removeUnusedObjects();
    }

    private void cleanUpPage(int pageNum, List<PdfCleanUpLocation> cleanUpLocations) throws IOException, DocumentException {
        if (cleanUpLocations.size() == 0) {
            return;
        }
        PdfReader pdfReader = this.pdfStamper.getReader();
        PdfDictionary page = pdfReader.getPageN(pageNum);
        PdfContentByte canvas = this.pdfStamper.getUnderContent(pageNum);
        byte[] pageContentInput = ContentByteUtils.getContentBytesForPage((PdfReader)pdfReader, (int)pageNum);
        page.remove(PdfName.CONTENTS);
        canvas.saveState();
        PdfCleanUpRegionFilter filter = this.createFilter(cleanUpLocations);
        PdfCleanUpRenderListener pdfCleanUpRenderListener = new PdfCleanUpRenderListener(this.pdfStamper, filter);
        pdfCleanUpRenderListener.registerNewContext(pdfReader.getPageResources(page), canvas);
        PdfContentStreamProcessor contentProcessor = new PdfContentStreamProcessor((RenderListener)pdfCleanUpRenderListener);
        PdfCleanUpContentOperator.populateOperators(contentProcessor, pdfCleanUpRenderListener);
        contentProcessor.processContent(pageContentInput, page.getAsDict(PdfName.RESOURCES));
        pdfCleanUpRenderListener.popContext();
        canvas.restoreState();
        this.colorCleanedLocations(canvas, cleanUpLocations);
        if (this.redactAnnotIndirRefs != null) {
            this.deleteRedactAnnots(pageNum);
        }
    }

    private PdfCleanUpRegionFilter createFilter(List<PdfCleanUpLocation> cleanUpLocations) {
        ArrayList<Rectangle> regions = new ArrayList<Rectangle>(cleanUpLocations.size());
        for (PdfCleanUpLocation location : cleanUpLocations) {
            regions.add(location.getRegion());
        }
        return new PdfCleanUpRegionFilter(regions);
    }

    private void colorCleanedLocations(PdfContentByte canvas, List<PdfCleanUpLocation> cleanUpLocations) {
        if (fillCleanedArea) {
            for (PdfCleanUpLocation location : cleanUpLocations) {
                if (location.getCleanUpColor() == null) continue;
                this.addColoredRectangle(canvas, location);
            }
        }
    }

    private void addColoredRectangle(PdfContentByte canvas, PdfCleanUpLocation cleanUpLocation) {
        Rectangle cleanUpRegion = cleanUpLocation.getRegion();
        canvas.saveState();
        canvas.setColorFill(cleanUpLocation.getCleanUpColor());
        canvas.moveTo(cleanUpRegion.getLeft(), cleanUpRegion.getBottom());
        canvas.lineTo(cleanUpRegion.getRight(), cleanUpRegion.getBottom());
        canvas.lineTo(cleanUpRegion.getRight(), cleanUpRegion.getTop());
        canvas.lineTo(cleanUpRegion.getLeft(), cleanUpRegion.getTop());
        canvas.closePath();
        canvas.fill();
        canvas.restoreState();
    }

    private Map<Integer, List<PdfCleanUpLocation>> organizeLocationsByPage(Collection<PdfCleanUpLocation> pdfCleanUpLocations) {
        HashMap<Integer, List<PdfCleanUpLocation>> organizedLocations = new HashMap<Integer, List<PdfCleanUpLocation>>();
        for (PdfCleanUpLocation location : pdfCleanUpLocations) {
            Integer page = location.getPage();
            if (!organizedLocations.containsKey(page)) {
                organizedLocations.put(page, new ArrayList());
            }
            ((List)organizedLocations.get(page)).add(location);
        }
        return organizedLocations;
    }

    private void extractLocationsFromRedactAnnots() {
        this.pdfCleanUpLocations = new HashMap<Integer, List<PdfCleanUpLocation>>();
        PdfReader reader = this.pdfStamper.getReader();
        for (int i = 1; i <= reader.getNumberOfPages(); ++i) {
            PdfDictionary pageDict = reader.getPageN(i);
            this.pdfCleanUpLocations.put(i, this.extractLocationsFromRedactAnnots(i, pageDict));
        }
    }

    private List<PdfCleanUpLocation> extractLocationsFromRedactAnnots(int page, PdfDictionary pageDict) {
        ArrayList<PdfCleanUpLocation> locations = new ArrayList<PdfCleanUpLocation>();
        if (pageDict.contains(PdfName.ANNOTS)) {
            PdfArray annotsArray = pageDict.getAsArray(PdfName.ANNOTS);
            for (int i = 0; i < annotsArray.size(); ++i) {
                PdfIndirectReference annotIndirRef = annotsArray.getAsIndirectObject(i);
                PdfDictionary annotDict = annotsArray.getAsDict(i);
                PdfName annotSubtype = annotDict.getAsName(PdfName.SUBTYPE);
                if (!annotSubtype.equals((Object)PdfName.REDACT)) continue;
                this.saveRedactAnnotIndirRef(page, annotIndirRef.toString());
                locations.addAll(this.extractLocationsFromRedactAnnot(page, i, annotDict));
            }
        }
        return locations;
    }

    private void saveRedactAnnotIndirRef(int page, String indRefStr) {
        if (!this.redactAnnotIndirRefs.containsKey(page)) {
            this.redactAnnotIndirRefs.put(page, new HashSet());
        }
        this.redactAnnotIndirRefs.get(page).add(indRefStr);
    }

    private List<PdfCleanUpLocation> extractLocationsFromRedactAnnot(int page, int annotIndex, PdfDictionary annotDict) {
        PdfStream ro;
        ArrayList<PdfCleanUpLocation> locations = new ArrayList<PdfCleanUpLocation>();
        ArrayList<Rectangle> markedRectangles = new ArrayList<Rectangle>();
        PdfArray quadPoints = annotDict.getAsArray(PdfName.QUADPOINTS);
        if (quadPoints.size() != 0) {
            markedRectangles.addAll(this.translateQuadPointsToRectangles(quadPoints));
        } else {
            PdfArray annotRect = annotDict.getAsArray(PdfName.RECT);
            markedRectangles.add(new Rectangle(annotRect.getAsNumber(0).floatValue(), annotRect.getAsNumber(1).floatValue(), annotRect.getAsNumber(2).floatValue(), annotRect.getAsNumber(3).floatValue()));
        }
        this.clippingRects.put(annotIndex, markedRectangles);
        BaseColor cleanUpColor = null;
        PdfArray ic = annotDict.getAsArray(PdfName.IC);
        if (ic != null) {
            cleanUpColor = new BaseColor(ic.getAsNumber(0).floatValue(), ic.getAsNumber(1).floatValue(), ic.getAsNumber(2).floatValue());
        }
        if ((ro = annotDict.getAsStream(PdfName.RO)) != null) {
            cleanUpColor = null;
        }
        for (Rectangle rect : markedRectangles) {
            locations.add(new PdfCleanUpLocation(page, rect, cleanUpColor));
        }
        return locations;
    }

    private List<Rectangle> translateQuadPointsToRectangles(PdfArray quadPoints) {
        ArrayList<Rectangle> rectangles = new ArrayList<Rectangle>();
        for (int i = 0; i < quadPoints.size(); i += 8) {
            rectangles.add(new Rectangle(quadPoints.getAsNumber(i + 4).floatValue(), quadPoints.getAsNumber(i + 5).floatValue(), quadPoints.getAsNumber(i + 2).floatValue(), quadPoints.getAsNumber(i + 3).floatValue()));
        }
        return rectangles;
    }

    private void deleteRedactAnnots(int pageNum) throws IOException, DocumentException {
        Set<String> indirRefs = this.redactAnnotIndirRefs.get(pageNum);
        if (indirRefs == null || indirRefs.isEmpty()) {
            return;
        }
        PdfReader reader = this.pdfStamper.getReader();
        PdfContentByte canvas = this.pdfStamper.getOverContent(pageNum);
        PdfDictionary pageDict = reader.getPageN(pageNum);
        PdfArray annotsArray = pageDict.getAsArray(PdfName.ANNOTS);
        int i = 0;
        int j = 0;
        while (i < annotsArray.size()) {
            PdfIndirectReference annotIndRef = annotsArray.getAsIndirectObject(i);
            PdfDictionary annotDict = annotsArray.getAsDict(i);
            if (indirRefs.contains(annotIndRef.toString()) || indirRefs.contains(this.getParentIndRefStr(annotDict))) {
                PdfStream formXObj = annotDict.getAsStream(PdfName.RO);
                PdfString overlayText = annotDict.getAsString(PdfName.OVERLAYTEXT);
                if (fillCleanedArea && formXObj != null) {
                    PdfArray rectArray = annotDict.getAsArray(PdfName.RECT);
                    Rectangle annotRect = new Rectangle(rectArray.getAsNumber(0).floatValue(), rectArray.getAsNumber(1).floatValue(), rectArray.getAsNumber(2).floatValue(), rectArray.getAsNumber(3).floatValue());
                    this.insertFormXObj(canvas, pageDict, formXObj, this.clippingRects.get(j), annotRect);
                } else if (fillCleanedArea && overlayText != null && overlayText.toUnicodeString().length() > 0) {
                    this.drawOverlayText(canvas, this.clippingRects.get(j), overlayText, annotDict.getAsString(PdfName.DA), annotDict.getAsNumber(PdfName.Q), annotDict.getAsBoolean(PdfName.REPEAT));
                }
                annotsArray.remove(i--);
            }
            ++i;
            ++j;
        }
        if (annotsArray.size() == 0) {
            pageDict.remove(PdfName.ANNOTS);
        }
    }

    private void insertFormXObj(PdfContentByte canvas, PdfDictionary pageDict, PdfStream formXObj, List<Rectangle> clippingRects, Rectangle annotRect) throws IOException {
        PdfName xobjName = this.generateNameForXObj(pageDict);
        canvas.saveState();
        for (Rectangle rect : clippingRects) {
            canvas.rectangle(rect.getLeft(), rect.getBottom(), rect.getWidth(), rect.getHeight());
        }
        canvas.clip();
        canvas.newPath();
        canvas.addFormXObj(formXObj, xobjName, 1.0f, 0.0f, 0.0f, 1.0f, annotRect.getLeft(), annotRect.getBottom());
        canvas.restoreState();
    }

    private void drawOverlayText(PdfContentByte canvas, List<Rectangle> textRectangles, PdfString overlayText, PdfString otDA, PdfNumber otQ, PdfBoolean otRepeat) throws DocumentException, IOException {
        ColumnText ct = new ColumnText(canvas);
        ct.setLeading(0.0f, 1.2f);
        ct.setUseAscender(true);
        String otStr = overlayText.toUnicodeString();
        canvas.saveState();
        Map<String, List> parsedDA = this.parseDAParam(otDA);
        Font font = null;
        if (parsedDA.containsKey(STROKE_COLOR)) {
            List strokeColorArgs = parsedDA.get(STROKE_COLOR);
            this.setStrokeColor(canvas, strokeColorArgs);
        }
        if (parsedDA.containsKey(FILL_COLOR)) {
            List fillColorArgs = parsedDA.get(FILL_COLOR);
            this.setFillColor(canvas, fillColorArgs);
        }
        if (parsedDA.containsKey("Tf")) {
            List tfArgs = parsedDA.get("Tf");
            font = this.retrieveFontFromAcroForm((PdfName)tfArgs.get(0), (PdfNumber)tfArgs.get(1));
        }
        for (Rectangle textRect : textRectangles) {
            ct.setSimpleColumn(textRect);
            if (otQ != null) {
                ct.setAlignment(otQ.intValue());
            }
            Phrase otPhrase = font != null ? new Phrase(otStr, font) : new Phrase(otStr);
            float y = ct.getYLine();
            if (otRepeat != null && otRepeat.booleanValue()) {
                int status = ct.go(true);
                while (!ColumnText.hasMoreText((int)status)) {
                    otPhrase.add(otStr);
                    ct.setText(otPhrase);
                    ct.setYLine(y);
                    status = ct.go(true);
                }
            }
            ct.setText(otPhrase);
            ct.setYLine(y);
            ct.go();
        }
        canvas.restoreState();
    }

    private Font retrieveFontFromAcroForm(PdfName fontName, PdfNumber size) {
        PdfIndirectReference fontIndirReference = this.pdfStamper.getReader().getAcroForm().getAsDict(PdfName.DR).getAsDict(PdfName.FONT).getAsIndirectObject(fontName);
        BaseFont bfont = BaseFont.createFont((PRIndirectReference)((PRIndirectReference)fontIndirReference));
        return new Font(bfont, size.floatValue());
    }

    Map<String, List> parseDAParam(PdfString DA) throws IOException {
        HashMap<String, List> commandArguments = new HashMap<String, List>();
        PRTokeniser tokeniser = new PRTokeniser(new RandomAccessFileOrArray(new RandomAccessSourceFactory().createSource(DA.getBytes())));
        ArrayList<Object> currentArguments = new ArrayList<Object>();
        block4: while (tokeniser.nextToken()) {
            if (tokeniser.getTokenType() == PRTokeniser.TokenType.OTHER) {
                String key = tokeniser.getStringValue();
                if (key.equals("RG") || key.equals("G") || key.equals("K")) {
                    key = STROKE_COLOR;
                } else if (key.equals("rg") || key.equals("g") || key.equals("k")) {
                    key = FILL_COLOR;
                }
                commandArguments.put(key, currentArguments);
                currentArguments = new ArrayList();
                continue;
            }
            switch (tokeniser.getTokenType()) {
                case NUMBER: {
                    currentArguments.add(new PdfNumber(tokeniser.getStringValue()));
                    continue block4;
                }
                case NAME: {
                    currentArguments.add(new PdfName(tokeniser.getStringValue()));
                    continue block4;
                }
            }
            currentArguments.add(tokeniser.getStringValue());
        }
        return commandArguments;
    }

    private String getParentIndRefStr(PdfDictionary dict) {
        return dict.getAsIndirectObject(PdfName.PARENT).toString();
    }

    private PdfName generateNameForXObj(PdfDictionary pageDict) {
        PdfDictionary resourcesDict = pageDict.getAsDict(PdfName.RESOURCES);
        PdfDictionary xobjDict = resourcesDict.getAsDict(PdfName.XOBJECT);
        if (xobjDict != null) {
            for (PdfName xobjName : xobjDict.getKeys()) {
                int xobjNum = this.getXObjNum(xobjName);
                if (this.currentXObjNum > xobjNum) continue;
                this.currentXObjNum = xobjNum + 1;
            }
        }
        return new PdfName(XOBJ_NAME_PREFIX + this.currentXObjNum++);
    }

    private int getXObjNum(PdfName xobjName) {
        String decodedPdfName = PdfName.decodeName((String)xobjName.toString());
        if (decodedPdfName.lastIndexOf(XOBJ_NAME_PREFIX) == -1) {
            return 0;
        }
        String numStr = decodedPdfName.substring(decodedPdfName.lastIndexOf(XOBJ_NAME_PREFIX) + XOBJ_NAME_PREFIX.length());
        return Integer.parseInt(numStr);
    }

    private void setFillColor(PdfContentByte canvas, List fillColorArgs) {
        switch (fillColorArgs.size()) {
            case 1: {
                canvas.setGrayFill(((PdfNumber)fillColorArgs.get(0)).floatValue());
                break;
            }
            case 3: {
                canvas.setRGBColorFillF(((PdfNumber)fillColorArgs.get(0)).floatValue(), ((PdfNumber)fillColorArgs.get(1)).floatValue(), ((PdfNumber)fillColorArgs.get(2)).floatValue());
                break;
            }
            case 4: {
                canvas.setCMYKColorFillF(((PdfNumber)fillColorArgs.get(0)).floatValue(), ((PdfNumber)fillColorArgs.get(1)).floatValue(), ((PdfNumber)fillColorArgs.get(2)).floatValue(), ((PdfNumber)fillColorArgs.get(3)).floatValue());
            }
        }
    }

    private void setStrokeColor(PdfContentByte canvas, List strokeColorArgs) {
        switch (strokeColorArgs.size()) {
            case 1: {
                canvas.setGrayStroke(((PdfNumber)strokeColorArgs.get(0)).floatValue());
                break;
            }
            case 3: {
                canvas.setRGBColorStrokeF(((PdfNumber)strokeColorArgs.get(0)).floatValue(), ((PdfNumber)strokeColorArgs.get(1)).floatValue(), ((PdfNumber)strokeColorArgs.get(2)).floatValue());
                break;
            }
            case 4: {
                canvas.setCMYKColorFillF(((PdfNumber)strokeColorArgs.get(0)).floatValue(), ((PdfNumber)strokeColorArgs.get(1)).floatValue(), ((PdfNumber)strokeColorArgs.get(2)).floatValue(), ((PdfNumber)strokeColorArgs.get(3)).floatValue());
            }
        }
    }
}

