/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import sun.security.ssl.Alert;
import sun.security.ssl.ChangeCipherSpec;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.ClientAuthType;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.ContentType;
import sun.security.ssl.HandshakeConsumer;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.RandomCookie;
import sun.security.ssl.Record;
import sun.security.ssl.SSLConfiguration;
import sun.security.ssl.SSLConsumer;
import sun.security.ssl.SSLExtension;
import sun.security.ssl.SSLExtensions;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLProducer;
import sun.security.ssl.SSLSessionContextImpl;
import sun.security.ssl.SSLSessionImpl;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.SessionId;
import sun.security.ssl.SupportedVersionsExtension;
import sun.security.ssl.TransportContext;
import sun.security.ssl.Utilities;

final class ClientHello {
    static final SSLProducer kickstartProducer = new ClientHelloKickstartProducer();
    static final SSLConsumer handshakeConsumer = new ClientHelloConsumer();
    static final HandshakeProducer handshakeProducer = new ClientHelloProducer();
    private static final HandshakeConsumer t12HandshakeConsumer = new T12ClientHelloConsumer();
    private static final HandshakeConsumer t13HandshakeConsumer = new T13ClientHelloConsumer();

    ClientHello() {
    }

    private static final class T13ClientHelloConsumer
    implements HandshakeConsumer {
        private T13ClientHelloConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            ClientHelloMessage clientHelloMessage = (ClientHelloMessage)handshakeMessage;
            if (serverHandshakeContext.conContext.isNegotiated) {
                throw serverHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Received unexpected renegotiation handshake message");
            }
            serverHandshakeContext.conContext.consumers.putIfAbsent(ContentType.CHANGE_CIPHER_SPEC.id, ChangeCipherSpec.t13Consumer);
            serverHandshakeContext.isResumption = true;
            SSLExtension[] sSLExtensionArray = new SSLExtension[]{SSLExtension.PSK_KEY_EXCHANGE_MODES, SSLExtension.CH_PRE_SHARED_KEY};
            clientHelloMessage.extensions.consumeOnLoad(serverHandshakeContext, sSLExtensionArray);
            sSLExtensionArray = serverHandshakeContext.sslConfig.getExclusiveExtensions(SSLHandshake.CLIENT_HELLO, Arrays.asList(SSLExtension.PSK_KEY_EXCHANGE_MODES, SSLExtension.CH_PRE_SHARED_KEY, SSLExtension.CH_SUPPORTED_VERSIONS));
            clientHelloMessage.extensions.consumeOnLoad(serverHandshakeContext, sSLExtensionArray);
            if (!serverHandshakeContext.handshakeProducers.isEmpty()) {
                this.goHelloRetryRequest(serverHandshakeContext, clientHelloMessage);
            } else {
                this.goServerHello(serverHandshakeContext, clientHelloMessage);
            }
        }

        private void goHelloRetryRequest(ServerHandshakeContext serverHandshakeContext, ClientHelloMessage clientHelloMessage) throws IOException {
            HandshakeProducer handshakeProducer = (HandshakeProducer)serverHandshakeContext.handshakeProducers.remove(SSLHandshake.HELLO_RETRY_REQUEST.id);
            if (handshakeProducer == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No HelloRetryRequest producer: " + serverHandshakeContext.handshakeProducers);
            }
            handshakeProducer.produce(serverHandshakeContext, clientHelloMessage);
            if (!serverHandshakeContext.handshakeProducers.isEmpty()) {
                throw serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "unknown handshake producers: " + serverHandshakeContext.handshakeProducers);
            }
        }

        private void goServerHello(ServerHandshakeContext serverHandshakeContext, ClientHelloMessage clientHelloMessage) throws IOException {
            SSLHandshake[] sSLHandshakeArray;
            serverHandshakeContext.clientHelloRandom = clientHelloMessage.clientRandom;
            if (!serverHandshakeContext.conContext.isNegotiated) {
                serverHandshakeContext.conContext.protocolVersion = serverHandshakeContext.negotiatedProtocol;
                serverHandshakeContext.conContext.outputRecord.setVersion(serverHandshakeContext.negotiatedProtocol);
            }
            serverHandshakeContext.handshakeProducers.put(SSLHandshake.SERVER_HELLO.id, SSLHandshake.SERVER_HELLO);
            for (SSLHandshake sSLHandshake : sSLHandshakeArray = new SSLHandshake[]{SSLHandshake.SERVER_HELLO, SSLHandshake.ENCRYPTED_EXTENSIONS, SSLHandshake.CERTIFICATE_REQUEST, SSLHandshake.CERTIFICATE, SSLHandshake.CERTIFICATE_VERIFY, SSLHandshake.FINISHED}) {
                HandshakeProducer handshakeProducer = (HandshakeProducer)serverHandshakeContext.handshakeProducers.remove(sSLHandshake.id);
                if (handshakeProducer == null) continue;
                handshakeProducer.produce(serverHandshakeContext, clientHelloMessage);
            }
        }
    }

    private static final class T12ClientHelloConsumer
    implements HandshakeConsumer {
        private T12ClientHelloConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            SSLHandshake[] sSLHandshakeArray;
            SSLExtension[] sSLExtensionArray;
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            ClientHelloMessage clientHelloMessage = (ClientHelloMessage)handshakeMessage;
            if (serverHandshakeContext.conContext.isNegotiated) {
                if (!serverHandshakeContext.conContext.secureRenegotiation && !HandshakeContext.allowUnsafeRenegotiation) {
                    throw serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Unsafe renegotiation is not allowed");
                }
                if (ServerHandshakeContext.rejectClientInitiatedRenego && !serverHandshakeContext.kickstartMessageDelivered) {
                    throw serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Client initiated renegotiation is not allowed");
                }
            }
            if (clientHelloMessage.sessionId.length() != 0) {
                String string;
                SSLHandshake[] sSLHandshakeArray2;
                boolean bl;
                block17: {
                    sSLExtensionArray = ((SSLSessionContextImpl)serverHandshakeContext.sslContext.engineGetServerSessionContext()).get(clientHelloMessage.sessionId.getId());
                    boolean bl2 = bl = sSLExtensionArray != null && sSLExtensionArray.isRejoinable();
                    if (!bl && SSLLogger.isOn && SSLLogger.isOn("ssl,handshake,verbose")) {
                        SSLLogger.finest("Can't resume, the existing session is not rejoinable", new Object[0]);
                    }
                    if (bl && (sSLHandshakeArray2 = sSLExtensionArray.getProtocolVersion()) != serverHandshakeContext.negotiatedProtocol) {
                        bl = false;
                        if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake,verbose")) {
                            SSLLogger.finest("Can't resume, not the same protocol version", new Object[0]);
                        }
                    }
                    if (bl && serverHandshakeContext.sslConfig.clientAuthType == ClientAuthType.CLIENT_AUTH_REQUIRED) {
                        try {
                            sSLExtensionArray.getPeerPrincipal();
                        }
                        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                            bl = false;
                            if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake,verbose")) break block17;
                            SSLLogger.finest("Can't resume, client authentication is required", new Object[0]);
                        }
                    }
                }
                if (!(!bl || serverHandshakeContext.isNegotiable((CipherSuite)(sSLHandshakeArray2 = sSLExtensionArray.getSuite())) && clientHelloMessage.cipherSuites.contains(sSLHandshakeArray2))) {
                    bl = false;
                    if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake,verbose")) {
                        SSLLogger.finest("Can't resume, the session cipher suite is absent", new Object[0]);
                    }
                }
                sSLHandshakeArray2 = serverHandshakeContext.sslConfig.identificationProtocol;
                if (bl && sSLHandshakeArray2 != null && !sSLHandshakeArray2.equalsIgnoreCase(string = sSLExtensionArray.getIdentificationProtocol())) {
                    if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake,verbose")) {
                        SSLLogger.finest("Can't resume, endpoint id algorithm does not match, requested: " + (String)sSLHandshakeArray2 + ", cached: " + string, new Object[0]);
                    }
                    bl = false;
                }
                serverHandshakeContext.isResumption = bl;
                Object object = serverHandshakeContext.resumingSession = bl ? sSLExtensionArray : null;
                if (!bl && SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Session not resumed.", new Object[0]);
                }
            }
            serverHandshakeContext.clientHelloRandom = clientHelloMessage.clientRandom;
            sSLExtensionArray = serverHandshakeContext.sslConfig.getEnabledExtensions(SSLHandshake.CLIENT_HELLO);
            clientHelloMessage.extensions.consumeOnLoad(serverHandshakeContext, sSLExtensionArray);
            if (!serverHandshakeContext.conContext.isNegotiated) {
                serverHandshakeContext.conContext.protocolVersion = serverHandshakeContext.negotiatedProtocol;
                serverHandshakeContext.conContext.outputRecord.setVersion(serverHandshakeContext.negotiatedProtocol);
            }
            serverHandshakeContext.handshakeProducers.put(SSLHandshake.SERVER_HELLO.id, SSLHandshake.SERVER_HELLO);
            for (SSLHandshake sSLHandshake : sSLHandshakeArray = new SSLHandshake[]{SSLHandshake.SERVER_HELLO, SSLHandshake.CERTIFICATE, SSLHandshake.CERTIFICATE_STATUS, SSLHandshake.SERVER_KEY_EXCHANGE, SSLHandshake.CERTIFICATE_REQUEST, SSLHandshake.SERVER_HELLO_DONE, SSLHandshake.FINISHED}) {
                HandshakeProducer handshakeProducer = (HandshakeProducer)serverHandshakeContext.handshakeProducers.remove(sSLHandshake.id);
                if (handshakeProducer == null) continue;
                handshakeProducer.produce(connectionContext, clientHelloMessage);
            }
        }
    }

    private static final class ClientHelloConsumer
    implements SSLConsumer {
        private ClientHelloConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            serverHandshakeContext.handshakeConsumers.remove(SSLHandshake.CLIENT_HELLO.id);
            if (!serverHandshakeContext.handshakeConsumers.isEmpty()) {
                throw serverHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "No more handshake message allowed in a ClientHello flight");
            }
            SSLExtension[] sSLExtensionArray = serverHandshakeContext.sslConfig.getEnabledExtensions(SSLHandshake.CLIENT_HELLO);
            ClientHelloMessage clientHelloMessage = new ClientHelloMessage(serverHandshakeContext, byteBuffer, sSLExtensionArray);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming ClientHello handshake message", clientHelloMessage);
            }
            serverHandshakeContext.clientHelloVersion = clientHelloMessage.clientVersion;
            this.onClientHello(serverHandshakeContext, clientHelloMessage);
        }

        private void onClientHello(ServerHandshakeContext serverHandshakeContext, ClientHelloMessage clientHelloMessage) throws IOException {
            SSLExtension[] sSLExtensionArray = new SSLExtension[]{SSLExtension.CH_SUPPORTED_VERSIONS};
            clientHelloMessage.extensions.consumeOnLoad(serverHandshakeContext, sSLExtensionArray);
            SupportedVersionsExtension.CHSupportedVersionsSpec cHSupportedVersionsSpec = (SupportedVersionsExtension.CHSupportedVersionsSpec)serverHandshakeContext.handshakeExtensions.get(SSLExtension.CH_SUPPORTED_VERSIONS);
            ProtocolVersion protocolVersion = cHSupportedVersionsSpec != null ? this.negotiateProtocol(serverHandshakeContext, cHSupportedVersionsSpec.requestedProtocols) : this.negotiateProtocol(serverHandshakeContext, clientHelloMessage.clientVersion);
            serverHandshakeContext.negotiatedProtocol = protocolVersion;
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Negotiated protocol version: " + protocolVersion.name, new Object[0]);
            }
            if (protocolVersion.useTLS13PlusSpec()) {
                t13HandshakeConsumer.consume(serverHandshakeContext, clientHelloMessage);
            } else {
                t12HandshakeConsumer.consume(serverHandshakeContext, clientHelloMessage);
            }
        }

        private ProtocolVersion negotiateProtocol(ServerHandshakeContext serverHandshakeContext, int n) throws SSLException {
            ProtocolVersion protocolVersion;
            int n2 = n;
            if (n2 > ProtocolVersion.TLS12.id) {
                n2 = ProtocolVersion.TLS12.id;
            }
            if ((protocolVersion = ProtocolVersion.selectedFrom(serverHandshakeContext.activeProtocols, n2)) == null || protocolVersion == ProtocolVersion.NONE || protocolVersion == ProtocolVersion.SSL20Hello) {
                throw serverHandshakeContext.conContext.fatal(Alert.PROTOCOL_VERSION, "Client requested protocol " + ProtocolVersion.nameOf(n) + " is not enabled or supported in server context");
            }
            return protocolVersion;
        }

        private ProtocolVersion negotiateProtocol(ServerHandshakeContext serverHandshakeContext, int[] nArray) throws SSLException {
            for (ProtocolVersion protocolVersion : serverHandshakeContext.activeProtocols) {
                if (protocolVersion == ProtocolVersion.SSL20Hello) continue;
                for (int n : nArray) {
                    if (n == ProtocolVersion.SSL20Hello.id || protocolVersion.id != n) continue;
                    return protocolVersion;
                }
            }
            throw serverHandshakeContext.conContext.fatal(Alert.PROTOCOL_VERSION, "The client supported protocol versions " + Arrays.toString(ProtocolVersion.toStringArray(nArray)) + " are not accepted by server preferences " + serverHandshakeContext.activeProtocols);
        }
    }

    private static final class ClientHelloProducer
    implements HandshakeProducer {
        private ClientHelloProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            SSLHandshake sSLHandshake = handshakeMessage.handshakeType();
            if (sSLHandshake == null) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
            switch (sSLHandshake) {
                case HELLO_REQUEST: {
                    try {
                        clientHandshakeContext.kickstart();
                    }
                    catch (IOException iOException) {
                        throw clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, iOException);
                    }
                    return null;
                }
                case HELLO_RETRY_REQUEST: {
                    if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                        SSLLogger.fine("Produced ClientHello(HRR) handshake message", clientHandshakeContext.initialClientHelloMsg);
                    }
                    clientHandshakeContext.initialClientHelloMsg.write(clientHandshakeContext.handshakeOutput);
                    clientHandshakeContext.handshakeOutput.flush();
                    clientHandshakeContext.conContext.consumers.putIfAbsent(ContentType.CHANGE_CIPHER_SPEC.id, ChangeCipherSpec.t13Consumer);
                    clientHandshakeContext.handshakeConsumers.put(SSLHandshake.SERVER_HELLO.id, SSLHandshake.SERVER_HELLO);
                    return null;
                }
            }
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static final class ClientHelloKickstartProducer
    implements SSLProducer {
        private ClientHelloKickstartProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext) throws IOException {
            Object object4;
            Object object22;
            Object object3;
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            clientHandshakeContext.handshakeProducers.remove(SSLHandshake.CLIENT_HELLO.id);
            SessionId sessionId = new SessionId(new byte[0]);
            List<CipherSuite> list = clientHandshakeContext.activeCipherSuites;
            SSLSessionContextImpl sSLSessionContextImpl = (SSLSessionContextImpl)clientHandshakeContext.sslContext.engineGetClientSessionContext();
            SSLSessionImpl sSLSessionImpl = sSLSessionContextImpl.get(clientHandshakeContext.conContext.transport.getPeerHost(), clientHandshakeContext.conContext.transport.getPeerPort());
            if (sSLSessionImpl != null) {
                if (!ClientHandshakeContext.allowUnsafeServerCertChange && sSLSessionImpl.isSessionResumption()) {
                    try {
                        clientHandshakeContext.reservedServerCerts = (X509Certificate[])sSLSessionImpl.getPeerCertificates();
                    }
                    catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                        // empty catch block
                    }
                }
                if (!sSLSessionImpl.isRejoinable()) {
                    sSLSessionImpl = null;
                    if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake,verbose")) {
                        SSLLogger.finest("Can't resume, the session is not rejoinable", new Object[0]);
                    }
                }
            }
            CipherSuite cipherSuite = null;
            if (sSLSessionImpl != null && !clientHandshakeContext.isNegotiable(cipherSuite = sSLSessionImpl.getSuite())) {
                sSLSessionImpl = null;
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake,verbose")) {
                    SSLLogger.finest("Can't resume, unavailable session cipher suite", new Object[0]);
                }
            }
            ProtocolVersion protocolVersion = null;
            if (sSLSessionImpl != null && !clientHandshakeContext.isNegotiable(protocolVersion = sSLSessionImpl.getProtocolVersion())) {
                sSLSessionImpl = null;
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake,verbose")) {
                    SSLLogger.finest("Can't resume, unavailable protocol version", new Object[0]);
                }
            }
            if (sSLSessionImpl != null && !protocolVersion.useTLS13PlusSpec() && SSLConfiguration.useExtendedMasterSecret) {
                boolean bl = clientHandshakeContext.sslConfig.isAvailable(SSLExtension.CH_EXTENDED_MASTER_SECRET, protocolVersion);
                if (bl && !sSLSessionImpl.useExtendedMasterSecret && !SSLConfiguration.allowLegacyResumption) {
                    sSLSessionImpl = null;
                }
                if (sSLSessionImpl != null && !ClientHandshakeContext.allowUnsafeServerCertChange && ((object3 = clientHandshakeContext.sslConfig.identificationProtocol) == null || object3.isEmpty())) {
                    if (bl) {
                        if (!sSLSessionImpl.useExtendedMasterSecret) {
                            sSLSessionImpl = null;
                        }
                    } else {
                        sSLSessionImpl = null;
                    }
                }
            }
            String string = clientHandshakeContext.sslConfig.identificationProtocol;
            if (sSLSessionImpl != null && string != null && !string.equalsIgnoreCase((String)(object3 = sSLSessionImpl.getIdentificationProtocol()))) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake,verbose")) {
                    SSLLogger.finest("Can't resume, endpoint id algorithm does not match, requested: " + string + ", cached: " + object3, new Object[0]);
                }
                sSLSessionImpl = null;
            }
            if (sSLSessionImpl != null) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake,verbose")) {
                    SSLLogger.finest("Try resuming session", sSLSessionImpl);
                }
                if (!sSLSessionImpl.getProtocolVersion().useTLS13PlusSpec()) {
                    sessionId = sSLSessionImpl.getSessionId();
                }
                if (!clientHandshakeContext.sslConfig.enableSessionCreation) {
                    list = !clientHandshakeContext.conContext.isNegotiated && !protocolVersion.useTLS13PlusSpec() && list.contains((Object)CipherSuite.TLS_EMPTY_RENEGOTIATION_INFO_SCSV) ? Arrays.asList(cipherSuite, CipherSuite.TLS_EMPTY_RENEGOTIATION_INFO_SCSV) : Arrays.asList(cipherSuite);
                    if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake,verbose")) {
                        SSLLogger.finest("No new session is allowed, so try to resume the session cipher suite only", new Object[]{cipherSuite});
                    }
                }
                clientHandshakeContext.isResumption = true;
                clientHandshakeContext.resumingSession = sSLSessionImpl;
            }
            if (sSLSessionImpl == null && !clientHandshakeContext.sslConfig.enableSessionCreation) {
                throw new SSLHandshakeException("No new session is allowed and no existing session can be resumed");
            }
            if (sessionId.length() == 0 && clientHandshakeContext.maximumActiveProtocol.useTLS13PlusSpec() && SSLConfiguration.useCompatibilityMode) {
                sessionId = new SessionId(true, clientHandshakeContext.sslContext.getSecureRandom());
            }
            object3 = ProtocolVersion.NONE;
            for (Object object22 : clientHandshakeContext.activeProtocols) {
                if (object3 != ProtocolVersion.NONE && object22.compare((ProtocolVersion)((Object)object3)) >= 0) continue;
                object3 = object22;
            }
            if (!((ProtocolVersion)((Object)object3)).useTLS13PlusSpec() && clientHandshakeContext.conContext.secureRenegotiation && list.contains((Object)CipherSuite.TLS_EMPTY_RENEGOTIATION_INFO_SCSV)) {
                list = new LinkedList<CipherSuite>(list);
                list.remove((Object)CipherSuite.TLS_EMPTY_RENEGOTIATION_INFO_SCSV);
            }
            boolean bl = false;
            for (Object object4 : list) {
                if (!clientHandshakeContext.isNegotiable((CipherSuite)((Object)object4))) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new SSLHandshakeException("No negotiable cipher suite");
            }
            object22 = clientHandshakeContext.maximumActiveProtocol;
            if (object22.useTLS13PlusSpec()) {
                object22 = ProtocolVersion.TLS12;
            }
            object4 = new ClientHelloMessage(clientHandshakeContext, object22.id, sessionId, list, clientHandshakeContext.sslContext.getSecureRandom());
            clientHandshakeContext.clientHelloRandom = ((ClientHelloMessage)object4).clientRandom;
            clientHandshakeContext.clientHelloVersion = object22.id;
            SSLExtension[] sSLExtensionArray = clientHandshakeContext.sslConfig.getEnabledExtensions(SSLHandshake.CLIENT_HELLO, clientHandshakeContext.activeProtocols);
            ((ClientHelloMessage)object4).extensions.produce(clientHandshakeContext, sSLExtensionArray);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced ClientHello handshake message", object4);
            }
            ((SSLHandshake.HandshakeMessage)object4).write(clientHandshakeContext.handshakeOutput);
            clientHandshakeContext.handshakeOutput.flush();
            clientHandshakeContext.initialClientHelloMsg = object4;
            clientHandshakeContext.handshakeConsumers.put(SSLHandshake.SERVER_HELLO.id, SSLHandshake.SERVER_HELLO);
            return null;
        }
    }

    static final class ClientHelloMessage
    extends SSLHandshake.HandshakeMessage {
        final int clientVersion;
        final RandomCookie clientRandom;
        final SessionId sessionId;
        final int[] cipherSuiteIds;
        final List<CipherSuite> cipherSuites;
        final byte[] compressionMethod;
        final SSLExtensions extensions;
        private static final byte[] NULL_COMPRESSION = new byte[]{0};

        ClientHelloMessage(HandshakeContext handshakeContext, int n, SessionId sessionId, List<CipherSuite> list, SecureRandom secureRandom) {
            super(handshakeContext);
            this.clientVersion = n;
            this.clientRandom = new RandomCookie(secureRandom);
            this.sessionId = sessionId;
            this.cipherSuites = list;
            this.cipherSuiteIds = ClientHelloMessage.getCipherSuiteIds(list);
            this.extensions = new SSLExtensions(this);
            this.compressionMethod = NULL_COMPRESSION;
        }

        static void readPartial(TransportContext transportContext, ByteBuffer byteBuffer) throws IOException {
            Record.getInt16(byteBuffer);
            new RandomCookie(byteBuffer);
            Record.getBytes8(byteBuffer);
            Record.getBytes16(byteBuffer);
            Record.getBytes8(byteBuffer);
            if (byteBuffer.remaining() >= 2) {
                int n;
                for (int i = Record.getInt16(byteBuffer); i > 0; i -= n + 4) {
                    int n2 = Record.getInt16(byteBuffer);
                    n = Record.getInt16(byteBuffer);
                    if (n2 == SSLExtension.CH_PRE_SHARED_KEY.id) {
                        if (i > 0) {
                            throw transportContext.fatal(Alert.ILLEGAL_PARAMETER, "pre_shared_key extension is not last");
                        }
                        Record.getBytes16(byteBuffer);
                        return;
                    }
                    byteBuffer.position(byteBuffer.position() + n);
                }
            }
        }

        ClientHelloMessage(HandshakeContext handshakeContext, ByteBuffer byteBuffer, SSLExtension[] sSLExtensionArray) throws IOException {
            super(handshakeContext);
            this.clientVersion = (byteBuffer.get() & 0xFF) << 8 | byteBuffer.get() & 0xFF;
            this.clientRandom = new RandomCookie(byteBuffer);
            this.sessionId = new SessionId(Record.getBytes8(byteBuffer));
            try {
                this.sessionId.checkLength(this.clientVersion);
            }
            catch (SSLProtocolException sSLProtocolException) {
                throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, sSLProtocolException);
            }
            byte[] byArray = Record.getBytes16(byteBuffer);
            if (byArray.length == 0 || (byArray.length & 1) != 0) {
                throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid ClientHello message");
            }
            this.cipherSuiteIds = new int[byArray.length >> 1];
            int n = 0;
            int n2 = 0;
            while (n < byArray.length) {
                this.cipherSuiteIds[n2] = (byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF;
                ++n;
                ++n2;
            }
            this.cipherSuites = ClientHelloMessage.getCipherSuites(this.cipherSuiteIds);
            this.compressionMethod = Record.getBytes8(byteBuffer);
            this.extensions = byteBuffer.hasRemaining() ? new SSLExtensions(this, byteBuffer, sSLExtensionArray) : new SSLExtensions(this);
        }

        byte[] getHeaderBytes() {
            HandshakeOutStream handshakeOutStream = new HandshakeOutStream(null);
            try {
                handshakeOutStream.putInt8((byte)(this.clientVersion >>> 8 & 0xFF));
                handshakeOutStream.putInt8((byte)(this.clientVersion & 0xFF));
                handshakeOutStream.write(this.clientRandom.randomBytes, 0, 32);
                handshakeOutStream.putBytes8(this.sessionId.getId());
                handshakeOutStream.putBytes16(this.getEncodedCipherSuites());
                handshakeOutStream.putBytes8(this.compressionMethod);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return handshakeOutStream.toByteArray();
        }

        private static int[] getCipherSuiteIds(List<CipherSuite> list) {
            if (list != null) {
                int[] nArray = new int[list.size()];
                int n = 0;
                for (CipherSuite cipherSuite : list) {
                    nArray[n++] = cipherSuite.id;
                }
                return nArray;
            }
            return new int[0];
        }

        private static List<CipherSuite> getCipherSuites(int[] nArray) {
            LinkedList<CipherSuite> linkedList = new LinkedList<CipherSuite>();
            for (int n : nArray) {
                CipherSuite cipherSuite = CipherSuite.valueOf(n);
                if (cipherSuite == null) continue;
                linkedList.add(cipherSuite);
            }
            return Collections.unmodifiableList(linkedList);
        }

        private List<String> getCipherSuiteNames() {
            LinkedList<String> linkedList = new LinkedList<String>();
            for (int n : this.cipherSuiteIds) {
                linkedList.add(CipherSuite.nameOf(n) + "(" + Utilities.byte16HexString(n) + ")");
            }
            return linkedList;
        }

        private byte[] getEncodedCipherSuites() {
            byte[] byArray = new byte[this.cipherSuiteIds.length << 1];
            int n = 0;
            for (int n2 : this.cipherSuiteIds) {
                byArray[n++] = (byte)(n2 >> 8);
                byArray[n++] = (byte)n2;
            }
            return byArray;
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.CLIENT_HELLO;
        }

        @Override
        public int messageLength() {
            return 38 + this.sessionId.length() + 0 + this.cipherSuiteIds.length * 2 + this.compressionMethod.length + this.extensions.length();
        }

        @Override
        public void send(HandshakeOutStream handshakeOutStream) throws IOException {
            this.sendCore(handshakeOutStream);
            this.extensions.send(handshakeOutStream);
        }

        void sendCore(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.putInt8((byte)(this.clientVersion >>> 8));
            handshakeOutStream.putInt8((byte)this.clientVersion);
            handshakeOutStream.write(this.clientRandom.randomBytes, 0, 32);
            handshakeOutStream.putBytes8(this.sessionId.getId());
            handshakeOutStream.putBytes16(this.getEncodedCipherSuites());
            handshakeOutStream.putBytes8(this.compressionMethod);
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"ClientHello\": '{'\n  \"client version\"      : \"{0}\",\n  \"random\"              : \"{1}\",\n  \"session id\"          : \"{2}\",\n  \"cipher suites\"       : \"{3}\",\n  \"compression methods\" : \"{4}\",\n  \"extensions\"          : [\n{5}\n  ]\n'}'", Locale.ENGLISH);
            Object[] objectArray = new Object[]{ProtocolVersion.nameOf(this.clientVersion), Utilities.toHexString(this.clientRandom.randomBytes), this.sessionId.toString(), this.getCipherSuiteNames().toString(), Utilities.toHexString(this.compressionMethod), Utilities.indent(Utilities.indent(this.extensions.toString()))};
            return messageFormat.format(objectArray);
        }
    }
}

