/*
 * Decompiled with CFR 0.152.
 */
package org.universis.signer;

import fi.iki.elonen.NanoHTTPD;
import fi.iki.elonen.router.RouterNanoHTTPD;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.universis.signer.BadRequestHandler;
import org.universis.signer.CorsHandler;
import org.universis.signer.FileStreamHandler;
import org.universis.signer.MethodNotAllowedHandler;
import org.universis.signer.OfficeDocumentSigner;
import org.universis.signer.ServerErrorHandler;
import org.universis.signer.SignerHandler;

public class EmbedHandler
implements RouterNanoHTTPD.UriResponder {
    private static final Logger log = LogManager.getLogger(SignerHandler.class);
    public HashMap<String, String> files = null;

    public NanoHTTPD.Response get(RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        return new MethodNotAllowedHandler().get(uriResource, map, ihttpSession);
    }

    public NanoHTTPD.Response put(RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        return new MethodNotAllowedHandler().get(uriResource, map, ihttpSession);
    }

    public NanoHTTPD.Response post(RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        try {
            String fileType;
            this.files = new HashMap();
            ihttpSession.parseBody(this.files);
            String file = null;
            for (String key : this.files.keySet()) {
                if (!key.startsWith("file")) continue;
                file = this.files.get(key);
                break;
            }
            if (file == null) {
                return new BadRequestHandler("Parameter file may not be null.").get(uriResource, map, ihttpSession);
            }
            Map params = ihttpSession.getParameters();
            if (!params.containsKey("file")) {
                return new BadRequestHandler("File parameter is missing").get(uriResource, map, ihttpSession);
            }
            String inFile = (String)((List)params.get("file")).get(0);
            switch (fileType = "." + FilenameUtils.getExtension((String)inFile).toLowerCase()) {
                case ".docx": 
                case ".xlsx": {
                    String outFileName = File.createTempFile("signatureLine", fileType).getAbsolutePath();
                    File outFile = new File(outFileName);
                    new OfficeDocumentSigner().embedSignatureLine(new File(file), outFile);
                    String contentType = fileType.equals(".xlsx") ? "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet" : "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
                    String contentDisposition = "attachment; filename=" + outFile.getName() + "\"";
                    NanoHTTPD.Response res = new FileStreamHandler(outFileName, contentType).get(uriResource, map, ihttpSession);
                    res.addHeader("Content-Disposition", contentDisposition);
                    CorsHandler.enable(res);
                    Map headers = ihttpSession.getHeaders();
                    if (headers.containsKey("origin")) {
                        res.addHeader("Access-Control-Allow-Origin", (String)headers.get("origin"));
                    }
                    return res;
                }
            }
            return new BadRequestHandler("File type is not supported.").get(uriResource, map, ihttpSession);
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return new ServerErrorHandler(e).get(uriResource, map, ihttpSession);
        }
    }

    public NanoHTTPD.Response delete(RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        return new MethodNotAllowedHandler().get(uriResource, map, ihttpSession);
    }

    public NanoHTTPD.Response other(String s, RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        return new CorsHandler().other(s, uriResource, map, ihttpSession);
    }
}

