/*
 * Decompiled with CFR 0.152.
 */
package org.universis.signer;

import fi.iki.elonen.NanoHTTPD;
import fi.iki.elonen.router.RouterNanoHTTPD;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.security.auth.login.FailedLoginException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.universis.signer.CorsHandler;
import org.universis.signer.ForbiddenHandler;
import org.universis.signer.JsonResponseHandler;
import org.universis.signer.MethodNotAllowedHandler;
import org.universis.signer.NotFoundHandler;
import org.universis.signer.ServerErrorHandler;
import org.universis.signer.SignerAppConfiguration;
import org.universis.signer.UnauthorizedHandler;
import org.universis.signer.X509CertificateInfo;

public class KeyStoreHandler
implements RouterNanoHTTPD.UriResponder {
    private static final Logger log = LogManager.getLogger(KeyStoreHandler.class);

    public NanoHTTPD.Response get(RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        String authorizationHeader = (String)ihttpSession.getHeaders().get("authorization");
        String contentType = (String)ihttpSession.getHeaders().get("content-type");
        if (authorizationHeader == null || !authorizationHeader.startsWith("Basic ")) {
            return new ForbiddenHandler().get(uriResource, map, ihttpSession);
        }
        byte[] decodedBytes = Base64.decodeBase64((String)authorizationHeader.replaceFirst("Basic ", ""));
        String[] usernamePassword = new String(decodedBytes).split(":");
        try {
            KeyStore ks;
            SignerAppConfiguration configuration = (SignerAppConfiguration)uriResource.initParameter(SignerAppConfiguration.class);
            if (configuration == null) {
                return new ServerErrorHandler("Application configuration cannot be empty at this context").get(uriResource, map, ihttpSession);
            }
            if (configuration.keyStore == null) {
                return new ServerErrorHandler("Invalid application configuration. Keystore cannot be empty at this context").get(uriResource, map, ihttpSession);
            }
            try {
                ks = configuration.getKeyStore(usernamePassword[1]);
            }
            catch (KeyStoreException e) {
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
                Throwable cause = e.getCause();
                if (cause instanceof NoSuchAlgorithmException) {
                    return new NotFoundHandler(e).get(uriResource, map, ihttpSession);
                }
                return new ServerErrorHandler(e).get(uriResource, map, ihttpSession);
            }
            catch (IOException e) {
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
                Throwable cause = e.getCause();
                if (cause instanceof BadPaddingException || cause instanceof FailedLoginException || cause instanceof UnrecoverableKeyException) {
                    return new UnauthorizedHandler(e).get(uriResource, map, ihttpSession);
                }
                return new ServerErrorHandler(e).get(uriResource, map, ihttpSession);
            }
            Enumeration<String> arr = ks.aliases();
            ArrayList<X509CertificateInfo> certs = new ArrayList<X509CertificateInfo>();
            while (arr.hasMoreElements()) {
                String alias = arr.nextElement();
                Certificate cert = ks.getCertificate(alias);
                if (!(cert instanceof X509Certificate)) continue;
                X509CertificateInfo info = new X509CertificateInfo((X509Certificate)cert);
                certs.add(info);
            }
            NanoHTTPD.Response res = new JsonResponseHandler(certs).get(uriResource, map, ihttpSession);
            CorsHandler.enable(res);
            Map headers = ihttpSession.getHeaders();
            if (headers.containsKey("origin")) {
                res.addHeader("Access-Control-Allow-Origin", (String)headers.get("origin"));
            }
            configuration.tryCloseKeyStore(ks);
            return res;
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return new ServerErrorHandler(e).get(uriResource, map, ihttpSession);
        }
    }

    public NanoHTTPD.Response put(RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        return new MethodNotAllowedHandler().get(uriResource, map, ihttpSession);
    }

    public NanoHTTPD.Response post(RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        return new MethodNotAllowedHandler().get(uriResource, map, ihttpSession);
    }

    public NanoHTTPD.Response delete(RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        return new MethodNotAllowedHandler().get(uriResource, map, ihttpSession);
    }

    public NanoHTTPD.Response other(String s, RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        return new CorsHandler().other(s, uriResource, map, ihttpSession);
    }
}

