/*
 * Decompiled with CFR 0.152.
 */
package org.universis.signer;

import fi.iki.elonen.NanoHTTPD;
import fi.iki.elonen.router.RouterNanoHTTPD;
import java.io.File;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.security.auth.login.FailedLoginException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.universis.signer.AuthHandler;
import org.universis.signer.BadRequestHandler;
import org.universis.signer.CorsHandler;
import org.universis.signer.FileStreamHandler;
import org.universis.signer.ForbiddenHandler;
import org.universis.signer.InvalidPositionException;
import org.universis.signer.MethodNotAllowedHandler;
import org.universis.signer.NotFoundHandler;
import org.universis.signer.OfficeDocumentSigner;
import org.universis.signer.ServerErrorHandler;
import org.universis.signer.SignConfiguration;
import org.universis.signer.SignerAppConfiguration;
import org.universis.signer.SignerHandler;
import org.universis.signer.UnauthorizedHandler;

public class OfficeDocumentSignHandler
implements RouterNanoHTTPD.UriResponder {
    public HashMap<String, String> files = null;
    private static final List<String> SupportedFileTypes = new ArrayList<String>(){
        {
            this.add(".docx");
            this.add(".xlsx");
        }
    };
    private static final Logger log = LogManager.getLogger(SignerHandler.class);

    public OfficeDocumentSignHandler() {
    }

    public OfficeDocumentSignHandler(HashMap<String, String> files) {
        this.files = files;
    }

    public NanoHTTPD.Response get(RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        return new MethodNotAllowedHandler().get(uriResource, map, ihttpSession);
    }

    public NanoHTTPD.Response put(RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        return new MethodNotAllowedHandler().get(uriResource, map, ihttpSession);
    }

    public NanoHTTPD.Response post(RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        SignerAppConfiguration configuration = null;
        KeyStore ks = null;
        try {
            SignConfiguration signConfiguration;
            UsernamePasswordCredentials user = AuthHandler.getUser(ihttpSession);
            if (user == null) {
                return new ForbiddenHandler().get(uriResource, map, ihttpSession);
            }
            configuration = (SignerAppConfiguration)uriResource.initParameter(SignerAppConfiguration.class);
            try {
                if (this.files == null) {
                    this.files = new HashMap();
                    ihttpSession.parseBody(this.files);
                    for (String string : this.files.values()) {
                    }
                }
                Map params = ihttpSession.getParameters();
                ArrayList<String> tmpFile = new ArrayList<String>();
                tmpFile.add(this.files.get("file"));
                params.put("tmpFile", tmpFile);
                signConfiguration = SignConfiguration.fromMap(params);
            }
            catch (InvalidPositionException e) {
                return new BadRequestHandler("Invalid signature position").get(uriResource, map, ihttpSession);
            }
            if (signConfiguration.originalFile == null) {
                return new BadRequestHandler("Parameter file may not be null.").get(uriResource, map, ihttpSession);
            }
            if (signConfiguration.thumbprint == null) {
                return new BadRequestHandler("Parameter thumbprint may not be null.").get(uriResource, map, ihttpSession);
            }
            String fileType = "." + FilenameUtils.getExtension((String)signConfiguration.originalFile).toLowerCase();
            if (SupportedFileTypes.contains(fileType)) {
                String contentType;
                try {
                    ks = configuration.getKeyStore(user.getPassword());
                }
                catch (KeyStoreException e) {
                    log.error(ExceptionUtils.getStackTrace((Throwable)e));
                    Throwable cause = e.getCause();
                    if (cause instanceof NoSuchAlgorithmException) {
                        return new NotFoundHandler(e).get(uriResource, map, ihttpSession);
                    }
                    return new ServerErrorHandler(e).get(uriResource, map, ihttpSession);
                }
                catch (IOException e) {
                    log.error(ExceptionUtils.getStackTrace((Throwable)e));
                    Throwable cause = e.getCause();
                    if (cause instanceof BadPaddingException || cause instanceof FailedLoginException || cause instanceof UnrecoverableKeyException) {
                        return new UnauthorizedHandler(e).get(uriResource, map, ihttpSession);
                    }
                    return new ServerErrorHandler(e).get(uriResource, map, ihttpSession);
                }
                switch (fileType) {
                    case ".xlsx": {
                        contentType = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
                        break;
                    }
                    case ".docx": {
                        contentType = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
                        break;
                    }
                    default: {
                        configuration.tryCloseKeyStore(ks);
                        return new BadRequestHandler("Unsupported document type.").get(uriResource, map, ihttpSession);
                    }
                }
                if (!this.files.containsKey("file")) {
                    configuration.tryCloseKeyStore(ks);
                    return new BadRequestHandler("Parameter file may not be null.").get(uriResource, map, ihttpSession);
                }
                String inFile = this.files.get("file");
                String outFile = File.createTempFile("signed", fileType).getAbsolutePath();
                OfficeDocumentSigner signer = new OfficeDocumentSigner(ks);
                signer.sign(new File(inFile), new File(outFile), signConfiguration.thumbprint, user.getPassword(), signConfiguration.reason, signConfiguration.timestampServer);
                File f = new File(outFile);
                if (!f.exists()) {
                    configuration.tryCloseKeyStore(ks);
                    return new NotFoundHandler().get(uriResource, map, ihttpSession);
                }
                String contentDisposition = "attachment; filename=\"" + f.getName() + "\"";
                NanoHTTPD.Response res = new FileStreamHandler(outFile, contentType).get(uriResource, map, ihttpSession);
                res.addHeader("Content-Disposition", contentDisposition);
                CorsHandler.enable(res);
                Map headers = ihttpSession.getHeaders();
                if (headers.containsKey("origin")) {
                    res.addHeader("Access-Control-Allow-Origin", (String)headers.get("origin"));
                }
                configuration.tryCloseKeyStore(ks);
                return res;
            }
            return new BadRequestHandler("Unsupported document type.").get(uriResource, map, ihttpSession);
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            if (configuration != null) {
                configuration.tryCloseKeyStore(ks);
            }
            return new ServerErrorHandler(e).get(uriResource, map, ihttpSession);
        }
    }

    public NanoHTTPD.Response delete(RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        return new MethodNotAllowedHandler().get(uriResource, map, ihttpSession);
    }

    public NanoHTTPD.Response other(String s, RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        return new CorsHandler().other(s, uriResource, map, ihttpSession);
    }
}

