/*
 * Decompiled with CFR 0.152.
 */
package org.universis.signer;

import com.itextpdf.text.pdf.security.PrivateKeySignature;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FileUtils;
import org.apache.jcp.xml.dsig.internal.dom.DOMSignedInfo;
import org.apache.jcp.xml.dsig.internal.dom.DOMSubTreeData;
import org.apache.poi.ooxml.util.DocumentHelper;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.poifs.crypt.HashAlgorithm;
import org.apache.poi.poifs.crypt.dsig.SignatureConfig;
import org.apache.poi.poifs.crypt.dsig.SignatureInfo;
import org.apache.poi.poifs.crypt.dsig.SignaturePart;
import org.apache.poi.poifs.crypt.dsig.facets.KeyInfoSignatureFacet;
import org.apache.poi.poifs.crypt.dsig.facets.OOXMLSignatureFacet;
import org.apache.poi.poifs.crypt.dsig.facets.Office2010SignatureFacet;
import org.apache.poi.poifs.crypt.dsig.facets.SignatureFacet;
import org.apache.poi.poifs.crypt.dsig.facets.XAdESSignatureFacet;
import org.apache.poi.poifs.crypt.dsig.services.RevocationData;
import org.apache.poi.poifs.crypt.dsig.services.TimeStampService;
import org.apache.poi.util.LocaleUtil;
import org.apache.xmlbeans.XmlException;
import org.universis.signer.SignatureProperties;
import org.universis.signer.VerifySignatureResult;
import org.universis.signer.X509CertificateInfo;
import org.w3.x2000.x09.xmldsig.KeyInfoType;
import org.w3.x2000.x09.xmldsig.SignatureDocument;
import org.w3.x2000.x09.xmldsig.SignatureType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sun.security.pkcs11.SunPKCS11;
import sun.security.pkcs11.wrapper.CK_MECHANISM_INFO;

public class OfficeDocumentSigner {
    private KeyStore _keyStore = null;

    public OfficeDocumentSigner() {
    }

    public OfficeDocumentSigner(KeyStore keyStore) {
        this._keyStore = keyStore;
    }

    private Element getDsigElement(Document document, String localName) {
        NodeList sigValNl = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", localName);
        if (sigValNl.getLength() == 1) {
            return (Element)sigValNl.item(0);
        }
        return null;
    }

    public static void tryFixingPKCS11ProviderBug(SunPKCS11 provider) {
        try {
            Field tokenField = SunPKCS11.class.getDeclaredField("token");
            tokenField.setAccessible(true);
            Object token = tokenField.get(provider);
            Field mechInfoMapField = token.getClass().getDeclaredField("mechInfoMap");
            mechInfoMapField.setAccessible(true);
            Map mechInfoMap = (Map)mechInfoMapField.get(token);
            mechInfoMap.put(6L, new CK_MECHANISM_INFO(1024L, 2048L, 0L));
        }
        catch (Exception e) {
            System.out.printf("Method tryFixingPKCS11ProviderBug failed with '%s'%n", e.getMessage());
        }
    }

    private Certificate[] getCertificateChain(KeyStore ks, String thumbprint) throws KeyStoreException, CertificateException, NoSuchAlgorithmException {
        Enumeration<String> aliases = ks.aliases();
        String alias = null;
        String findAlias = null;
        while (aliases.hasMoreElements()) {
            String certThumbprint;
            alias = aliases.nextElement();
            Certificate cert = ks.getCertificate(alias);
            if (!(cert instanceof X509Certificate) || !thumbprint.equals((certThumbprint = X509CertificateInfo.getThumbprint((X509Certificate)cert)).toLowerCase())) continue;
            findAlias = alias;
            break;
        }
        if (findAlias == null) {
            throw new CertificateException("The specified certificate cannot be found");
        }
        return ks.getCertificateChain(alias);
    }

    private PrivateKey getPrivateKey(KeyStore ks, String thumbprint, String password) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        Enumeration<String> aliases = ks.aliases();
        String alias = null;
        String findAlias = null;
        while (aliases.hasMoreElements()) {
            String certThumbprint;
            alias = aliases.nextElement();
            Certificate cert = ks.getCertificate(alias);
            if (!(cert instanceof X509Certificate) || !thumbprint.equals((certThumbprint = X509CertificateInfo.getThumbprint((X509Certificate)cert)).toLowerCase())) continue;
            findAlias = alias;
            break;
        }
        if (findAlias == null) {
            throw new CertificateException("The specified certificate cannot be found");
        }
        return (PrivateKey)ks.getKey(alias, password.toCharArray());
    }

    public void sign(File inFile, File outFile, String thumbprint, String password, String reason, String timestampServer) throws GeneralSecurityException, IOException, InvalidFormatException, XMLSignatureException, MarshalException, TransformException, NoSuchFieldException {
        if (this._keyStore == null) {
            throw new KeyStoreException("Key store cannot be empty at this context");
        }
        KeyStore ks = this._keyStore;
        PrivateKey privateKey = this.getPrivateKey(ks, thumbprint, password);
        Certificate[] chain = this.getCertificateChain(ks, thumbprint);
        if (!inFile.equals(outFile)) {
            FileUtils.copyFile((File)inFile, (File)outFile);
        }
        OPCPackage pkg = OPCPackage.open((File)outFile, (PackageAccess)PackageAccess.READ_WRITE);
        SignatureConfig signatureConfig = new SignatureConfig();
        if (timestampServer == null) {
            TimeStampService tspService = new TimeStampService(){

                public byte[] timeStamp(byte[] data, RevocationData revocationData) throws Exception {
                    return "time-stamp-token".getBytes(LocaleUtil.CHARSET_1252);
                }

                public void setSignatureConfig(SignatureConfig config) {
                }
            };
            signatureConfig.setTspService(tspService);
        } else {
            signatureConfig.setTspUrl(timestampServer);
        }
        signatureConfig.setTspRequestPolicy(null);
        signatureConfig.setDigestAlgo(HashAlgorithm.sha1);
        ArrayList<X509Certificate> certificateChain = new ArrayList<X509Certificate>();
        for (Certificate cert : chain) {
            certificateChain.add((X509Certificate)cert);
        }
        signatureConfig.setSigningCertificateChain(certificateChain);
        signatureConfig.setKey(privateKey);
        if (reason != null) {
            signatureConfig.setSignatureDescription("Document signature");
        }
        signatureConfig.addSignatureFacet((SignatureFacet)new OOXMLSignatureFacet());
        signatureConfig.addSignatureFacet((SignatureFacet)new KeyInfoSignatureFacet());
        signatureConfig.addSignatureFacet((SignatureFacet)new XAdESSignatureFacet());
        signatureConfig.addSignatureFacet((SignatureFacet)new Office2010SignatureFacet());
        signatureConfig.setIncludeEntireCertificateChain(true);
        signatureConfig.setOpcPackage(pkg);
        SignatureInfo si = new SignatureInfo();
        si.setSignatureConfig(signatureConfig);
        Document document = DocumentHelper.createDocument();
        DOMSignContext xmlSignContext = si.createXMLSignContext(document);
        xmlSignContext.setProperty("org.jcp.xml.dsig.internal.dom.SignatureProvider", ks.getProvider());
        DOMSignedInfo signedInfo = si.preSign(xmlSignContext);
        if (ks.getProvider() instanceof SunPKCS11) {
            Document doc = (Document)xmlSignContext.getParent();
            Element el = this.getDsigElement(doc, "SignedInfo");
            DOMSubTreeData subTree = new DOMSubTreeData((Node)el, true);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            signedInfo.getCanonicalizationMethod().transform((Data)subTree, xmlSignContext, stream);
            PrivateKeySignature pks = new PrivateKeySignature(privateKey, "SHA-1", ks.getProvider().getName());
            byte[] res = pks.sign(stream.toByteArray());
            String signatureValue = Base64.getEncoder().encodeToString(res);
            si.postSign(xmlSignContext, signatureValue);
        } else {
            String signatureValue = si.signDigest(xmlSignContext, signedInfo);
            si.postSign(xmlSignContext, signatureValue);
        }
        pkg.close();
    }

    public VerifySignatureResult verify(File inFile) throws InvalidFormatException {
        OPCPackage pkg = OPCPackage.open((File)inFile, (PackageAccess)PackageAccess.READ);
        SignatureConfig signatureConfig = new SignatureConfig();
        signatureConfig.addSignatureFacet((SignatureFacet)new OOXMLSignatureFacet());
        signatureConfig.addSignatureFacet((SignatureFacet)new KeyInfoSignatureFacet());
        signatureConfig.addSignatureFacet((SignatureFacet)new XAdESSignatureFacet());
        signatureConfig.addSignatureFacet((SignatureFacet)new Office2010SignatureFacet());
        signatureConfig.setOpcPackage(pkg);
        SignatureInfo si = new SignatureInfo();
        si.setSignatureConfig(signatureConfig);
        VerifySignatureResult result = new VerifySignatureResult();
        result.signatureProperties = new SignatureProperties();
        result.valid = si.verifySignature();
        result.certificates = new ArrayList<X509CertificateInfo>();
        for (SignaturePart signaturePart : si.getSignatureParts()) {
            try {
                SignatureDocument signatureDocument = signaturePart.getSignatureDocument();
                SignatureType signature = signatureDocument.getSignature();
                KeyInfoType keyInfo = signature.getKeyInfo();
                List x509DataList = keyInfo.getX509DataList();
                x509DataList.forEach(x509DataType -> {
                    byte[][] x509CertificateArray = x509DataType.getX509CertificateArray();
                    CertificateFactory certFactory = null;
                    try {
                        certFactory = CertificateFactory.getInstance("X.509");
                        for (byte[] bytes : x509CertificateArray) {
                            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                            X509Certificate cert = (X509Certificate)certFactory.generateCertificate(in);
                            X509CertificateInfo info = new X509CertificateInfo(cert);
                            result.certificates.add(info);
                        }
                    }
                    catch (IOException | NoSuchAlgorithmException | CertificateException e) {
                        e.printStackTrace();
                    }
                });
                NamespaceContext ctx = new NamespaceContext(){

                    @Override
                    public String getNamespaceURI(String prefix) {
                        if (prefix.equals("xd")) {
                            return "http://uri.etsi.org/01903/v1.3.2#";
                        }
                        if (prefix.equals("ns0")) {
                            return "http://www.w3.org/2000/09/xmldsig#";
                        }
                        return null;
                    }

                    public Iterator getPrefixes(String val) {
                        return null;
                    }

                    @Override
                    public String getPrefix(String uri) {
                        return null;
                    }
                };
                XPath xPath = XPathFactory.newInstance().newXPath();
                xPath.setNamespaceContext(ctx);
                try {
                    Node serialNumberNode;
                    Node signedSignaturePropertiesNode = (Node)xPath.compile("//xd:QualifyingProperties/xd:SignedProperties/xd:SignedSignatureProperties").evaluate(signature.getDomNode(), XPathConstants.NODE);
                    if (signedSignaturePropertiesNode == null) continue;
                    Node signingTimeNode = (Node)xPath.compile("./xd:SigningTime").evaluate(signedSignaturePropertiesNode, XPathConstants.NODE);
                    if (signingTimeNode != null && signingTimeNode.getChildNodes().getLength() > 0) {
                        String text = signingTimeNode.getChildNodes().item(0).getNodeValue();
                        if (!text.endsWith("Z")) {
                            text = text + "Z";
                        }
                        result.signatureProperties.signingDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").parse(text);
                    }
                    if ((serialNumberNode = (Node)xPath.compile("./xd:SigningCertificate/xd:Cert/xd:IssuerSerial/ns0:X509SerialNumber").evaluate(signedSignaturePropertiesNode, XPathConstants.NODE)) == null) continue;
                    String serialNumber = serialNumberNode.getChildNodes().item(0).getNodeValue();
                    result.certificates.forEach(x509CertificateInfo -> {
                        if (x509CertificateInfo.serialNumber.toString().equals(serialNumber)) {
                            result.signatureProperties.signingCertificate = x509CertificateInfo;
                        }
                    });
                }
                catch (ParseException | XPathExpressionException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException | XmlException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public void embedSignatureLine(File inFile, File outFile) throws InvalidFormatException, IOException {
        OPCPackage pkg = OPCPackage.open((File)inFile, (PackageAccess)PackageAccess.READ_WRITE);
        ArrayList parts = pkg.getParts();
        for (PackagePart part : parts) {
            if (!part.getPartName().getName().equals("/xl/drawings/vmlDrawing1.vml")) continue;
            pkg.removePart(part);
            break;
        }
        for (PackagePart part : parts) {
            if (!part.getPartName().getName().equals("/xl/media/image1.emf")) continue;
            pkg.removePart(part);
            break;
        }
        PackagePartName vmlDrawing1Name = PackagingURIHelper.createPartName((String)"/xl/drawings/vmlDrawing1.vml");
        PackagePart vmlDrawing1 = pkg.createPart(vmlDrawing1Name, "application/vnd.openxmlformats-officedocument.vmlDrawing");
        vmlDrawing1.load(OfficeDocumentSigner.class.getResourceAsStream("/org/universis/signer/signatureLine/drawings/vmlDrawing1.vml"));
        PackagePartName image1Name = PackagingURIHelper.createPartName((String)"/xl/media/image1.emf");
        PackagePart image1 = pkg.createPart(image1Name, "image/x-emf");
        image1.load(OfficeDocumentSigner.class.getResourceAsStream("/org/universis/signer/signatureLine/media/image1.emf"));
        vmlDrawing1.addRelationship(image1Name, TargetMode.INTERNAL, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/image");
        parts = pkg.getParts();
        PackagePart findPart = null;
        for (PackagePart part : parts) {
            if (!part.getContentType().equals("application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml")) continue;
            findPart = part;
            break;
        }
        if (findPart == null) {
            throw new IOException("Document spreadsheet cannot be found");
        }
        findPart.addRelationship(vmlDrawing1Name, TargetMode.INTERNAL, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/vmlDrawing");
        pkg.save(outFile);
    }
}

