/*
 * Decompiled with CFR 0.152.
 */
package org.universis.signer;

import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.parser.ImageRenderInfo;
import com.itextpdf.text.pdf.parser.LineSegment;
import com.itextpdf.text.pdf.parser.RenderListener;
import com.itextpdf.text.pdf.parser.TextRenderInfo;
import org.universis.signer.SignatureBlockConfiguration;

public class SignaturePositionListener
implements RenderListener {
    public SignatureBlockConfiguration configuration = new SignatureBlockConfiguration();
    public Rectangle position;

    public SignaturePositionListener() {
    }

    public SignaturePositionListener(SignatureBlockConfiguration options) {
        this.configuration = options;
    }

    @Override
    public void beginTextBlock() {
    }

    @Override
    public void endTextBlock() {
    }

    @Override
    public void renderImage(ImageRenderInfo renderInfo) {
    }

    @Override
    public void renderText(TextRenderInfo renderInfo) {
        String text = renderInfo.getText();
        if (this.configuration.signatureBlockText.contains(text)) {
            LineSegment ls = this.configuration.signatureBlockTextPosition.contains("top") ? renderInfo.getDescentLine() : renderInfo.getAscentLine();
            int x = (int)ls.getBoundingRectange().getX();
            int y = (int)ls.getBoundingRectange().getY();
            int textWidth = (int)ls.getBoundingRectange().width;
            int textHeight = (int)renderInfo.getAscentLine().getBoundingRectange().y - (int)renderInfo.getDescentLine().getBoundingRectange().y;
            int paddingX = 0;
            int paddingY = 5;
            int signatureWidth = this.configuration.signatureBlockWidth;
            int signatureHeight = this.configuration.signatureBlockHeight - textHeight - paddingY;
            int xCenter = x - (signatureWidth - textWidth) / 2 + paddingX;
            int xRight = x - (signatureWidth - textWidth) + paddingX;
            switch (this.configuration.signatureBlockTextPosition) {
                case "center top": {
                    int x1 = xCenter;
                    int y1 = y + paddingY;
                    this.position = new Rectangle(x1, y1, x1 + signatureWidth, y1 - signatureHeight);
                    break;
                }
                case "right top": {
                    int x1 = xRight;
                    int y1 = y + paddingY;
                    this.position = new Rectangle(x1, y1, x1 + signatureWidth, y1 - signatureHeight);
                    break;
                }
                case "left bottom": {
                    this.position = new Rectangle(x, y, x + signatureWidth, y + signatureHeight);
                    break;
                }
                case "center bottom": {
                    int x1 = xCenter;
                    this.position = new Rectangle(x1, y, x1 + signatureWidth, y + signatureHeight);
                    break;
                }
                case "right bottom": {
                    int x1 = xRight;
                    this.position = new Rectangle(x1, y, x1 + signatureWidth, y + signatureHeight);
                    break;
                }
                default: {
                    int x1 = x;
                    int y1 = y + paddingY;
                    this.position = new Rectangle(x1, y1, x1 + signatureWidth, y1 - signatureHeight);
                }
            }
        }
    }
}

