/*
 * Decompiled with CFR 0.152.
 */
package org.universis.signer;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfSignatureAppearance;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.security.BouncyCastleDigest;
import com.itextpdf.text.pdf.security.MakeSignature;
import com.itextpdf.text.pdf.security.PdfPKCS7;
import com.itextpdf.text.pdf.security.PrivateKeySignature;
import com.itextpdf.text.pdf.security.TSAClientBouncyCastle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.List;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.universis.signer.SignatureProperties;
import org.universis.signer.VerifySignatureResult;
import org.universis.signer.X509CertificateInfo;

public class Signer {
    private KeyStore _keyStore;

    public Signer(KeyStore keyStore) {
        this._keyStore = keyStore;
    }

    public Signer() {
    }

    public void sign(InputStream inputStream, OutputStream outputStream, String thumbprint, String password, String reason, int page, Rectangle position, String timestampServer, String name, String image) throws IOException, DocumentException, GeneralSecurityException {
        PdfReader reader = new PdfReader(inputStream);
        PdfStamper stamper = PdfStamper.createSignature(reader, outputStream, '\u0000', null, true);
        PdfSignatureAppearance appearance = stamper.getSignatureAppearance();
        if (reason != null) {
            appearance.setReason(reason);
        }
        Font font = new Font(Font.FontFamily.HELVETICA, 10.0f);
        appearance.setLayer2Font(font);
        Rectangle finalPosition = new Rectangle(50.0f, 10.0f, 290.0f, 100.0f);
        if (position != null) {
            finalPosition = position;
        }
        if (image != null) {
            Image imageInstance = Image.getInstance(image);
            appearance.setSignatureGraphic(imageInstance);
            appearance.setRenderingMode(PdfSignatureAppearance.RenderingMode.GRAPHIC_AND_DESCRIPTION);
        }
        appearance.setVisibleSignature(finalPosition, page, name == null ? "sig" : name);
        BouncyCastleProvider provider = new BouncyCastleProvider();
        Security.addProvider((Provider)provider);
        String providerName = provider.getName();
        KeyStore ks = this._keyStore;
        Enumeration<String> aliases = ks.aliases();
        String alias = null;
        String findAlias = null;
        while (aliases.hasMoreElements()) {
            String certThumbprint;
            alias = aliases.nextElement();
            Certificate cert = ks.getCertificate(alias);
            if (!(cert instanceof X509Certificate) || !thumbprint.equals((certThumbprint = X509CertificateInfo.getThumbprint((X509Certificate)cert)).toLowerCase())) continue;
            findAlias = alias;
            break;
        }
        if (findAlias == null) {
            throw new CertificateException("The specified certificate cannot be found");
        }
        Key key = ks.getKey(alias, password.toCharArray());
        Certificate[] chain = ks.getCertificateChain(alias);
        PrivateKeySignature pks = null;
        pks = ks.getType().toLowerCase().equals("pkcs11") ? new PrivateKeySignature((PrivateKey)key, "SHA-256", ks.getProvider().getName()) : new PrivateKeySignature((PrivateKey)key, "SHA-256", providerName);
        BouncyCastleDigest digest = new BouncyCastleDigest();
        TSAClientBouncyCastle tsaClient = null;
        if (timestampServer != null) {
            tsaClient = new TSAClientBouncyCastle(timestampServer, "", "");
        }
        MakeSignature.signDetached(appearance, digest, pks, chain, null, null, tsaClient, 0, MakeSignature.CryptoStandard.CMS);
    }

    public void sign(String inFile, String outFile, String thumbprint, String password, String reason, int page, Rectangle position, String timestampServer) throws IOException, DocumentException, GeneralSecurityException {
        this.sign(new FileInputStream(inFile), new FileOutputStream(outFile), thumbprint, password, reason, page, position, timestampServer, null, null);
    }

    public void sign(String inFile, String outFile, String thumbprint, String password, String reason, int page, Rectangle position, String timestampServer, String name, String imageFile) throws IOException, DocumentException, GeneralSecurityException {
        this.sign(new FileInputStream(inFile), new FileOutputStream(outFile), thumbprint, password, reason, page, position, timestampServer, name, imageFile);
    }

    public List<VerifySignatureResult> verify(File inFile) throws InvalidFormatException, IOException, GeneralSecurityException {
        BouncyCastleProvider provider = new BouncyCastleProvider();
        Security.addProvider((Provider)provider);
        String providerName = provider.getName();
        PdfReader pdfReader = new PdfReader(new FileInputStream(inFile));
        AcroFields acroFields = pdfReader.getAcroFields();
        ArrayList<String> signatureNames = acroFields.getSignatureNames();
        ArrayList<VerifySignatureResult> results = new ArrayList<VerifySignatureResult>();
        if (!signatureNames.isEmpty()) {
            for (String name : signatureNames) {
                if (!acroFields.signatureCoversWholeDocument(name)) continue;
                VerifySignatureResult result = new VerifySignatureResult();
                Security.getProviders();
                PdfPKCS7 pkcs7 = acroFields.verifySignature(name, providerName);
                result.valid = pkcs7.verify();
                String reason = pkcs7.getReason();
                Calendar signedAt = pkcs7.getSignDate();
                X509Certificate signingCertificate = pkcs7.getSigningCertificate();
                result.certificates = new ArrayList<X509CertificateInfo>();
                result.certificates.add(new X509CertificateInfo(signingCertificate));
                result.signatureProperties = new SignatureProperties();
                result.signatureProperties.reason = reason;
                result.signatureProperties.signingCertificate = new X509CertificateInfo(signingCertificate);
                result.signatureProperties.signingDate = signedAt.getTime();
                results.add(result);
            }
        }
        return results;
    }
}

