/*
 * Decompiled with CFR 0.152.
 */
package org.universis.signer;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import dorkbox.systemTray.Entry;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.SystemTray;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.universis.signer.SignerApp;
import org.universis.signer.SignerAppConfiguration;

public class SignerController
extends JDialog {
    private JPanel contentPane;
    private JLabel splash;
    private JButton buttonStartStop;
    private JButton buttonCancel;
    private JLabel lastMessage;
    private static SignerApp signerApp;
    private static SystemTray systemTray;
    private static SignerController currentController;
    private static final Logger log;
    private boolean standalone = false;

    public SignerController() {
        this.$$$setupUI$$$();
        this.createUIComponents();
    }

    private static void useSystemTray() {
        InputStream trayIconStream = SignerApp.class.getResourceAsStream("/org/universis/signer/public/universis-signer-icon.png");
        systemTray = SystemTray.get();
        if (systemTray == null) {
            log.error("Unable to load SystemTray. Signer controller will be loaded as standalone application.");
            currentController = new SignerController();
            SignerController.currentController.standalone = true;
            currentController.pack();
            currentController.setVisible(true);
            return;
        }
        try {
            systemTray.setImage(trayIconStream);
        }
        catch (Exception e2) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e2));
        }
        if (signerApp != null) {
            systemTray.setStatus("Universis signer is running");
        } else {
            systemTray.setStatus("Universis signer is stopped");
        }
        systemTray.getMenu().add((Entry)new MenuItem("About", e -> {
            try {
                if (currentController != null) {
                    currentController.setVisible(true);
                    currentController.toFront();
                    currentController.repaint();
                    return;
                }
                currentController = new SignerController();
                currentController.pack();
                currentController.setVisible(true);
            }
            catch (Exception err) {
                log.error((Object)err);
                log.error(ExceptionUtils.getStackTrace((Throwable)err));
                JOptionPane.showMessageDialog(null, "An error occurred while showing service controller. " + err.getMessage(), "Universis signer", 0);
            }
        }));
        systemTray.getMenu().add((Entry)new MenuItem("Hide", e -> {
            if (currentController == null) {
                return;
            }
            currentController.setVisible(false);
        }));
        systemTray.getMenu().add((Entry)new MenuItem("Quit", e -> SignerController.stopServiceAndExit()));
    }

    private static void stopServiceAndExit() {
        try {
            int confirmClose = JOptionPane.showConfirmDialog(null, "You are going to stop Universis signer. Do you want to continue?", "Universis Signer", 2);
            if (confirmClose == 2) {
                return;
            }
            SignerController.stopService();
            if (currentController != null) {
                currentController.dispose();
                currentController = null;
            }
            if (systemTray != null) {
                systemTray.shutdown();
            }
            System.exit(0);
        }
        catch (Exception err) {
            log.error((Object)err);
            log.error(ExceptionUtils.getStackTrace((Throwable)err));
            JOptionPane.showMessageDialog(null, "An error occurred while stopping service. " + err.getMessage(), "Universis signer", 0);
        }
    }

    public static void startService(final SignerAppConfiguration configuration) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TimeUnit.SECONDS.sleep(3L);
                    signerApp = new SignerApp(configuration);
                    signerApp.start();
                    if (systemTray != null) {
                        systemTray.setStatus("Universis signer is running");
                    }
                }
                catch (IOException | InterruptedException e) {
                    log.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }).start();
    }

    public static void stopService() {
        if (signerApp != null) {
            signerApp.stop();
            if (systemTray != null) {
                systemTray.setStatus("Universis signer is stopped");
            }
        }
    }

    private void onStartStop() {
        this.dispose();
    }

    private void onClose() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SignerController.stopServiceAndExit();
                }
                catch (Exception e) {
                    log.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }).start();
    }

    public static void main(String[] args) {
        try {
            InputStream inputStream;
            CommandLine cmd;
            log.info("Starting Universis signer controller");
            SignerAppConfiguration configuration = new SignerAppConfiguration();
            log.debug("Getting command-line arguments");
            Options options = new Options();
            Option configOption = new Option("c", "config", true, "service configuration e.g. -config ./service.properties");
            configOption.setRequired(false);
            options.addOption(configOption);
            DefaultParser parser = new DefaultParser();
            HelpFormatter formatter = new HelpFormatter();
            try {
                cmd = parser.parse(options, args);
            }
            catch (ParseException e) {
                log.error((Object)e);
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
                System.exit(1);
                return;
            }
            String configurationFile = cmd.getOptionValue("config");
            Properties properties = new Properties();
            if (configurationFile != null) {
                log.info("Try to load configuration from file");
                inputStream = new FileInputStream(configurationFile);
            } else if (new File("extras/service.properties").exists()) {
                log.info("Try to load configuration from default location");
                inputStream = new FileInputStream("extras/service.properties");
            } else {
                log.info("Try to load configuration from resource");
                inputStream = SignerController.class.getResourceAsStream("service.properties");
            }
            properties.load(inputStream);
            configuration.keyStore = properties.getProperty("keyStore");
            configuration.storeType = properties.getProperty("storeType");
            configuration.providerArg = properties.getProperty("providerArg");
            configuration.daemon = true;
            configuration.loadRoutesFromFile("extras/routes.xml");
            log.info("Starting Universis signer service");
            SignerController.startService(configuration);
            log.info("Registering application to system tray");
            SignerController.useSystemTray();
        }
        catch (Exception err) {
            log.error("Universis signer service controller failed to start.");
            log.error(ExceptionUtils.getStackTrace((Throwable)err));
            System.exit(1);
        }
    }

    private void createUIComponents() {
        this.setContentPane(this.contentPane);
        this.setResizable(false);
        this.setTitle("Universis signer controller");
        this.buttonStartStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SignerController.this.onStartStop();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SignerController.this.onClose();
            }
        });
        if (signerApp != null) {
            if (signerApp.wasStarted()) {
                this.lastMessage.setText("Universis signer has been successfully started.");
                this.lastMessage.setForeground(Color.decode("#0000ff"));
            } else {
                this.lastMessage.setText("Universis signer has not been started yet.");
                this.lastMessage.setForeground(Color.decode("#0000ff"));
            }
        } else {
            this.lastMessage.setText("Universis signer has not been started yet.");
            this.lastMessage.setForeground(Color.decode("#ff00ff"));
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (SignerController.this.standalone) {
                    SignerController.stopServiceAndExit();
                    return;
                }
                SignerController.this.setVisible(false);
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SignerController.this.standalone) {
                    SignerController.stopServiceAndExit();
                    return;
                }
                SignerController.this.setVisible(false);
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
    }

    private void $$$setupUI$$$() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(10, 10, 10, 10), -1, -1));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.contentPane.add((Component)panel1, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 1, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        panel1.add((Component)spacer1, new GridConstraints(0, 0, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, true, false));
        panel1.add((Component)panel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.buttonStartStop = new JButton();
        this.buttonStartStop.setEnabled(false);
        this.buttonStartStop.setText("Stop service");
        panel2.add((Component)this.buttonStartStop, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.buttonCancel = new JButton();
        this.buttonCancel.setText("Stop service and exit");
        panel2.add((Component)this.buttonCancel, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        JPanel panel3 = new JPanel();
        panel3.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.contentPane.add((Component)panel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(24, 300), null, 0, false));
        this.splash = new JLabel();
        this.splash.setBackground(new Color(-1));
        this.splash.setIcon(new ImageIcon(this.getClass().getResource("/org/universis/signer/public/universis-signer-label.png")));
        this.splash.setText("");
        panel3.add((Component)this.splash, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null, 0, false));
        this.lastMessage = new JLabel();
        this.lastMessage.setText("Universis Signer is starting...");
        this.lastMessage.setVerticalAlignment(1);
        this.lastMessage.setVerticalTextPosition(0);
        panel3.add((Component)this.lastMessage, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    static {
        log = LogManager.getLogger(SignerController.class);
    }
}

