/*
 * Decompiled with CFR 0.152.
 */
package org.universis.signer;

import fi.iki.elonen.NanoHTTPD;
import fi.iki.elonen.router.RouterNanoHTTPD;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.universis.signer.CorsHandler;
import org.universis.signer.ForbiddenHandler;
import org.universis.signer.JsonResponseHandler;
import org.universis.signer.MethodNotAllowedHandler;
import org.universis.signer.ServerErrorHandler;
import org.universis.signer.SignerAppConfiguration;
import org.universis.signer.SlotInfo;
import sun.security.pkcs11.wrapper.PKCS11Exception;

public class SlotHandler
implements RouterNanoHTTPD.UriResponder {
    private static final Logger log = LogManager.getLogger(SlotHandler.class);

    public NanoHTTPD.Response get(RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        try {
            SignerAppConfiguration configuration = (SignerAppConfiguration)uriResource.initParameter(SignerAppConfiguration.class);
            if (configuration == null) {
                return new ServerErrorHandler("Application configuration cannot be empty at this context").get(uriResource, map, ihttpSession);
            }
            if (configuration.keyStore == null) {
                return new ServerErrorHandler("Invalid application configuration. Keystore cannot be empty at this context").get(uriResource, map, ihttpSession);
            }
            try {
                boolean notAvailableOnly;
                boolean availableOnly = true;
                Map params = ihttpSession.getParameters();
                if (params.containsKey("availableOnly") && (notAvailableOnly = ((String)((List)params.get("availableOnly")).get(0)).toLowerCase().equals("false"))) {
                    availableOnly = false;
                }
                SlotInfo[] slots = configuration.getSlots(availableOnly);
                NanoHTTPD.Response res = new JsonResponseHandler((Serializable)slots).get(uriResource, map, ihttpSession);
                CorsHandler.enable(res);
                Map headers = ihttpSession.getHeaders();
                if (headers.containsKey("origin")) {
                    res.addHeader("Access-Control-Allow-Origin", (String)headers.get("origin"));
                }
                return res;
            }
            catch (IllegalAccessException e) {
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
                return new ForbiddenHandler().get(uriResource, map, ihttpSession);
            }
            catch (PKCS11Exception e) {
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
                return new ServerErrorHandler(e.getMessage()).get(uriResource, map, ihttpSession);
            }
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return new ServerErrorHandler(e).get(uriResource, map, ihttpSession);
        }
    }

    public NanoHTTPD.Response put(RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        return new MethodNotAllowedHandler().get(uriResource, map, ihttpSession);
    }

    public NanoHTTPD.Response post(RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        return new MethodNotAllowedHandler().get(uriResource, map, ihttpSession);
    }

    public NanoHTTPD.Response delete(RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        return new MethodNotAllowedHandler().get(uriResource, map, ihttpSession);
    }

    public NanoHTTPD.Response other(String s, RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        return new CorsHandler().other(s, uriResource, map, ihttpSession);
    }
}

