/*
 * Decompiled with CFR 0.152.
 */
package org.universis.signer;

import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.xml.bind.DatatypeConverter;
import org.bouncycastle.jce.X509Principal;
import sun.security.x509.X500Name;

public class X509CertificateInfo {
    public int version;
    public String subjectDN;
    public String sigAlgName;
    public String sigAlgOID;
    public String issuerDN;
    public BigInteger serialNumber;
    public Date notAfter;
    public Date notBefore;
    public boolean expired;
    public String thumbprint;
    public String commonName;

    public X509CertificateInfo(X509Certificate cert) throws CertificateEncodingException, NoSuchAlgorithmException, IOException {
        this.version = cert.getVersion();
        this.subjectDN = cert.getSubjectDN().getName();
        boolean isX509Principal = cert.getSubjectDN() instanceof X509Principal;
        if (!isX509Principal) {
            this.commonName = ((X500Name)cert.getSubjectDN()).getCommonName();
        }
        this.sigAlgName = cert.getSigAlgName();
        this.sigAlgOID = cert.getSigAlgOID();
        this.issuerDN = cert.getIssuerDN().getName();
        this.serialNumber = cert.getSerialNumber();
        this.notAfter = cert.getNotAfter();
        this.notBefore = cert.getNotBefore();
        this.expired = !this.notAfter.after(new Date()) || !this.notBefore.before(new Date());
        this.thumbprint = X509CertificateInfo.getThumbprint(cert);
    }

    public static String getThumbprint(X509Certificate cert) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] der = cert.getEncoded();
        md.update(der);
        byte[] digest = md.digest();
        String digestHex = DatatypeConverter.printHexBinary((byte[])digest);
        return digestHex.toLowerCase();
    }
}

