/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png.chunks;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.InflaterInputStream;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.formats.png.AbstractPngText;
import org.apache.commons.imaging.formats.png.chunks.AbstractPngTextChunk;
import org.apache.commons.io.IOUtils;

public class PngChunkItxt
extends AbstractPngTextChunk {
    private final String keyword;
    private final String text;
    private final String languageTag;
    private final String translatedKeyword;

    public PngChunkItxt(int length, int chunkType, int crc, byte[] bytes) throws ImagingException, IOException {
        super(length, chunkType, crc, bytes);
        int terminator = BinaryFunctions.findNull(bytes, "PNG iTXt chunk keyword is not terminated.");
        this.keyword = new String(bytes, 0, terminator, StandardCharsets.ISO_8859_1);
        int index = terminator + 1;
        byte compressionFlag = bytes[index++];
        if (compressionFlag != 0 && compressionFlag != 1) {
            throw new ImagingException("PNG iTXt chunk has invalid compression flag: " + compressionFlag);
        }
        boolean compressed = compressionFlag == 1;
        byte compressionMethod = bytes[index++];
        if (compressed && compressionMethod != 0) {
            throw new ImagingException("PNG iTXt chunk has unexpected compression method: " + compressionMethod);
        }
        terminator = BinaryFunctions.findNull(bytes, index, "PNG iTXt chunk language tag is not terminated.");
        this.languageTag = new String(bytes, index, terminator - index, StandardCharsets.ISO_8859_1);
        index = terminator + 1;
        terminator = BinaryFunctions.findNull(bytes, index, "PNG iTXt chunk translated keyword is not terminated.");
        this.translatedKeyword = new String(bytes, index, terminator - index, StandardCharsets.UTF_8);
        index = terminator + 1;
        if (compressed) {
            int compressedTextLength = bytes.length - index;
            byte[] compressedText = Allocator.byteArray(compressedTextLength);
            System.arraycopy(bytes, index, compressedText, 0, compressedTextLength);
            this.text = new String(IOUtils.toByteArray((InputStream)new InflaterInputStream(new ByteArrayInputStream(compressedText))), StandardCharsets.UTF_8);
        } else {
            this.text = new String(bytes, index, bytes.length - index, StandardCharsets.UTF_8);
        }
    }

    @Override
    public AbstractPngText getContents() {
        return new AbstractPngText.Itxt(this.keyword, this.text, this.languageTag, this.translatedKeyword);
    }

    @Override
    public String getKeyword() {
        return this.keyword;
    }

    @Override
    public String getText() {
        return this.text;
    }

    public String getTranslatedKeyword() {
        return this.translatedKeyword;
    }
}

