/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import sun.security.util.DerOutputStream;
import sun.security.util.KnownOIDs;
import sun.security.util.ObjectIdentifier;

public class NamedCurve
extends ECParameterSpec {
    private final String[] nameAndAliases;
    private final String oid;
    private final byte[] encoded;

    NamedCurve(KnownOIDs knownOIDs, EllipticCurve ellipticCurve, ECPoint eCPoint, BigInteger bigInteger, int n) {
        super(ellipticCurve, eCPoint, bigInteger, n);
        String[] stringArray = knownOIDs.aliases();
        this.nameAndAliases = new String[stringArray.length + 1];
        this.nameAndAliases[0] = knownOIDs.stdName();
        System.arraycopy(stringArray, 0, this.nameAndAliases, 1, stringArray.length);
        this.oid = knownOIDs.value();
        DerOutputStream derOutputStream = new DerOutputStream();
        try {
            derOutputStream.putOID(ObjectIdentifier.of(knownOIDs));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Internal error", iOException);
        }
        this.encoded = derOutputStream.toByteArray();
    }

    public String[] getNameAndAliases() {
        return this.nameAndAliases;
    }

    byte[] getEncoded() {
        return (byte[])this.encoded.clone();
    }

    public String getObjectId() {
        return this.oid;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.nameAndAliases[0]);
        if (this.nameAndAliases.length > 1) {
            stringBuilder.append(" [");
            int n = 1;
            while (n < this.nameAndAliases.length - 1) {
                stringBuilder.append(this.nameAndAliases[n++]);
                stringBuilder.append(',');
            }
            stringBuilder.append(this.nameAndAliases[n] + "]");
        }
        stringBuilder.append(" (" + this.oid + ")");
        return stringBuilder.toString();
    }
}

