/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import sun.security.util.ChannelBindingException;

public class TlsChannelBinding {
    private final TlsChannelBindingType cbType;
    private final byte[] cbData;

    public static TlsChannelBindingType parseType(String string) throws ChannelBindingException {
        if (string != null) {
            if (string.equals(TlsChannelBindingType.TLS_SERVER_END_POINT.getName())) {
                return TlsChannelBindingType.TLS_SERVER_END_POINT;
            }
            throw new ChannelBindingException("Illegal value for channel binding type: " + string);
        }
        return null;
    }

    public static TlsChannelBinding create(X509Certificate x509Certificate) throws ChannelBindingException {
        try {
            byte[] byArray = TlsChannelBindingType.TLS_SERVER_END_POINT.getName().concat(":").getBytes();
            String string = x509Certificate.getSigAlgName().replace("SHA", "SHA-").toUpperCase();
            int n = string.indexOf("WITH");
            if (n > 0) {
                if ((string = string.substring(0, n)).equals("MD5") || string.equals("SHA-1")) {
                    string = "SHA-256";
                }
            } else {
                string = "SHA-256";
            }
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            byte[] byArray2 = messageDigest.digest(x509Certificate.getEncoded());
            byte[] byArray3 = Arrays.copyOf(byArray, byArray.length + byArray2.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
            return new TlsChannelBinding(TlsChannelBindingType.TLS_SERVER_END_POINT, byArray3);
        }
        catch (NoSuchAlgorithmException | CertificateEncodingException generalSecurityException) {
            throw new ChannelBindingException("Cannot create TLS channel binding data", generalSecurityException);
        }
    }

    private TlsChannelBinding(TlsChannelBindingType tlsChannelBindingType, byte[] byArray) {
        this.cbType = tlsChannelBindingType;
        this.cbData = byArray;
    }

    public TlsChannelBindingType getType() {
        return this.cbType;
    }

    public byte[] getData() {
        return this.cbData;
    }

    public static enum TlsChannelBindingType {
        TLS_UNIQUE("tls-unique"),
        TLS_SERVER_END_POINT("tls-server-end-point");

        private final String name;

        public String getName() {
            return this.name;
        }

        private TlsChannelBindingType(String string2) {
            this.name = string2;
        }
    }
}

