/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

import dorkbox.util.FileUtil;
import dorkbox.util.LocationResolver;
import dorkbox.util.OS;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;

public class CacheUtil {
    private static final MessageDigest digest;
    public static String tempDir;

    public static synchronized void clear() {
        FileUtil.delete(new File(OS.TEMP_DIR, tempDir), new String[0]);
    }

    public static synchronized File check(File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        return CacheUtil.check(file.getAbsolutePath());
    }

    public static synchronized File check(String fileName) {
        if (fileName == null) {
            throw new NullPointerException("fileName");
        }
        File newFile = CacheUtil.makeCacheFile(fileName);
        if (newFile.canRead() && newFile.isFile()) {
            return newFile;
        }
        return null;
    }

    public static synchronized File check(URL fileResource) {
        if (fileResource == null) {
            throw new NullPointerException("fileResource");
        }
        return CacheUtil.check(fileResource.getPath());
    }

    public static synchronized File check(InputStream fileStream) throws IOException {
        if (fileStream == null) {
            throw new NullPointerException("fileStream");
        }
        return CacheUtil.check(null, fileStream);
    }

    public static synchronized File check(String cacheName, InputStream fileStream) throws IOException {
        File newFile;
        if (fileStream == null) {
            throw new NullPointerException("fileStream");
        }
        if (cacheName == null) {
            cacheName = CacheUtil.createNameAsHash(fileStream);
        }
        if ((newFile = CacheUtil.makeCacheFile(cacheName)).canRead() && newFile.isFile()) {
            return newFile;
        }
        return null;
    }

    public static synchronized File save(File file) throws IOException {
        return CacheUtil.save(file.getAbsolutePath(), file);
    }

    public static synchronized File save(String cacheName, File file) throws IOException {
        if (cacheName == null) {
            cacheName = file.getAbsolutePath();
        }
        return CacheUtil.save(cacheName, file.getAbsolutePath());
    }

    public static synchronized File save(String fileName) throws IOException {
        return CacheUtil.save(null, fileName);
    }

    public static synchronized File save(String cacheName, String fileName) throws IOException {
        File newFile;
        if (cacheName == null) {
            cacheName = fileName;
        }
        if ((newFile = CacheUtil.makeCacheFile(cacheName)).canRead() && newFile.isFile()) {
            return newFile;
        }
        File iconTest = new File(fileName);
        if (iconTest.isFile()) {
            if (!iconTest.canRead()) {
                throw new IOException("File exists but unable to read source file " + fileName);
            }
            FileUtil.copyFile(iconTest, newFile);
            return newFile;
        }
        URL systemResource = LocationResolver.getResource(fileName);
        if (systemResource == null) {
            throw new IOException("Unable to load URL resource " + fileName);
        }
        InputStream inStream = systemResource.openStream();
        return CacheUtil.makeFileViaStream(cacheName, inStream);
    }

    public static synchronized File save(URL fileResource) throws IOException {
        return CacheUtil.save(null, fileResource);
    }

    public static synchronized File save(String cacheName, URL fileResource) throws IOException {
        File newFile;
        if (cacheName == null) {
            cacheName = fileResource.getPath();
        }
        if ((newFile = CacheUtil.makeCacheFile(cacheName)).canRead() && newFile.isFile()) {
            return newFile;
        }
        InputStream inStream = fileResource.openStream();
        return CacheUtil.makeFileViaStream(cacheName, inStream);
    }

    public static synchronized File save(InputStream fileStream) throws IOException {
        if (fileStream == null) {
            throw new NullPointerException("fileStream");
        }
        return CacheUtil.save(null, fileStream);
    }

    public static synchronized File save(String cacheName, InputStream fileStream) throws IOException {
        File newFile;
        if (cacheName == null) {
            cacheName = CacheUtil.createNameAsHash(fileStream);
        }
        if ((newFile = CacheUtil.makeCacheFile(cacheName)).canRead() && newFile.isFile()) {
            return newFile;
        }
        return CacheUtil.makeFileViaStream(cacheName, fileStream);
    }

    private static File makeFileViaStream(String cacheName, InputStream resourceStream) throws IOException {
        if (resourceStream == null) {
            throw new NullPointerException("resourceStream");
        }
        if (cacheName == null) {
            throw new NullPointerException("cacheName");
        }
        File newFile = CacheUtil.makeCacheFile(cacheName);
        if (newFile.canRead() && newFile.isFile()) {
            return newFile.getAbsoluteFile();
        }
        FileOutputStream outStream = null;
        try {
            int read;
            byte[] buffer = new byte[2048];
            outStream = new FileOutputStream(newFile);
            while ((read = resourceStream.read(buffer)) > 0) {
                ((OutputStream)outStream).write(buffer, 0, read);
            }
        }
        catch (IOException e) {
            String message = "Unable to copy '" + cacheName + "' to temporary location: '" + newFile.getAbsolutePath() + "'";
            throw new IOException(message, e);
        }
        finally {
            try {
                resourceStream.close();
            }
            catch (Exception exception) {}
            try {
                if (outStream != null) {
                    ((OutputStream)outStream).close();
                }
            }
            catch (Exception exception) {}
        }
        return newFile.getAbsoluteFile();
    }

    public static synchronized File create(String cacheName) {
        return CacheUtil.makeCacheFile(cacheName);
    }

    private static File makeCacheFile(String cacheName) {
        if (cacheName == null) {
            throw new NullPointerException("cacheName");
        }
        File saveDir = new File(OS.TEMP_DIR, tempDir);
        String hash = CacheUtil.hashName(cacheName);
        String extension = FileUtil.getExtension(cacheName);
        if (extension.isEmpty()) {
            extension = "cache";
        }
        File newFile = new File(saveDir, hash + '.' + extension).getAbsoluteFile();
        newFile.getParentFile().mkdirs();
        return newFile;
    }

    private static String hashName(String name) {
        byte[] bytes = name.getBytes(OS.UTF_8);
        digest.reset();
        digest.update(bytes);
        return new BigInteger(1, digest.digest()).toString(32).toUpperCase(Locale.US);
    }

    public static synchronized String createNameAsHash(InputStream resourceStream) throws IOException {
        digest.reset();
        try {
            int read;
            ByteArrayOutputStream outStream = new ByteArrayOutputStream(4096);
            byte[] buffer = new byte[2048];
            while ((read = resourceStream.read(buffer)) > 0) {
                digest.update(buffer, 0, read);
                outStream.write(buffer, 0, read);
            }
            String string = new BigInteger(1, digest.digest()).toString(32).toUpperCase(Locale.US) + ".cache";
            return string;
        }
        catch (IOException e) {
            String message = "Unable to copy InputStream to memory.";
            throw new IOException(message, e);
        }
        finally {
            try {
                resourceStream.close();
            }
            catch (Exception exception) {}
        }
    }

    static {
        MessageDigest digest_ = null;
        try {
            digest_ = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to initialize hash algorithm for images. MD5 digest doesn't exist.");
        }
        digest = digest_;
        tempDir = "";
    }
}

