/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

import com.sun.jna.Callback;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.StdCallFunctionMapper;
import dorkbox.util.OS;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class ClassLoaderUtil {
    public static void defineClass(byte[] bytes) throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Method defineClass = ClassLoader.class.getDeclaredMethod("defineClass", byte[].class, Integer.TYPE, Integer.TYPE);
        defineClass.setAccessible(true);
        defineClass.invoke((Object)classLoader, bytes, 0, bytes.length);
    }

    public static class Bootstrap {
        public static final int JNI_VERSION_1_1 = 65537;
        public static final int JNI_VERSION_1_2 = 65538;
        public static final int JNI_VERSION_1_4 = 65540;
        public static final int JNI_VERSION_1_6 = 65542;
        public static final int JNI_VERSION_1_7 = 65543;
        public static final int JNI_VERSION_1_8 = 65544;
        public static int JNI_VERSION;
        private static JVM libjvm;

        public static void defineClass(byte[] classBytes) throws Exception {
            int[] jvmCount = new int[]{100};
            libjvm.JNI_GetCreatedJavaVMs(null, 0, jvmCount);
            JavaVM.ByReference[] vms = new JavaVM.ByReference[jvmCount[0]];
            int vmsLength = vms.length;
            for (int i = 0; i < vmsLength; ++i) {
                vms[i] = new JavaVM.ByReference();
            }
            libjvm.JNI_GetCreatedJavaVMs(vms, vms.length, jvmCount);
            Exception exception = null;
            for (int i = 0; i < jvmCount[0]; ++i) {
                JavaVM.ByReference vm = vms[i];
                PointerByReference penv = new PointerByReference();
                vm.functions.GetEnv.callback(vm, penv, JNI_VERSION);
                try {
                    libjvm.JVM_DefineClass(penv.getValue(), null, null, classBytes, classBytes.length, null);
                    continue;
                }
                catch (Exception e) {
                    exception = e;
                }
            }
            if (exception != null) {
                throw exception;
            }
        }

        static {
            String libName;
            JNI_VERSION = 65540;
            if (OS.isMacOsX()) {
                if (OS.javaVersion < 7) {
                    libName = "JavaVM";
                } else {
                    String javaLocation = System.getProperty("java.home");
                    libName = javaLocation + "/lib/server/libjvm.dylib";
                }
            } else {
                libName = "jvm";
            }
            if (OS.isWindows() && OS.is32bit()) {
                HashMap<String, 1> options = new HashMap<String, 1>();
                options.put("function-mapper", new StdCallFunctionMapper(){

                    public String getFunctionName(NativeLibrary library, Method method) {
                        String methodName = method.getName();
                        if (methodName.equals("JVM_DefineClass")) {
                            return "_JVM_DefineClass@24";
                        }
                        return methodName;
                    }
                });
                libjvm = (JVM)Native.loadLibrary((String)libName, JVM.class, options);
            } else {
                libjvm = (JVM)Native.loadLibrary((String)libName, JVM.class);
            }
        }

        public static class JNIInvokeInterface
        extends Structure {
            public volatile Pointer reserved0;
            public volatile Pointer reserved1;
            public volatile Pointer reserved2;
            public volatile Pointer DestroyJavaVM;
            public volatile Pointer AttachCurrentThread;
            public volatile Pointer DetachCurrentThread;
            public volatile GetEnv GetEnv;
            public volatile Pointer AttachCurrentThreadAsDaemon;

            protected List getFieldOrder() {
                return Arrays.asList("reserved0", "reserved1", "reserved2", "DestroyJavaVM", "AttachCurrentThread", "DetachCurrentThread", "GetEnv", "AttachCurrentThreadAsDaemon");
            }

            public static interface GetEnv
            extends Callback {
                public int callback(JavaVM.ByReference var1, PointerByReference var2, int var3);
            }

            public static class ByReference
            extends JNIInvokeInterface
            implements Structure.ByReference {
            }
        }

        public static interface JVM
        extends Library {
            public void JVM_DefineClass(Pointer var1, String var2, Object var3, byte[] var4, int var5, Object var6);

            public int JNI_GetCreatedJavaVMs(JavaVM.ByReference[] var1, int var2, int[] var3);
        }

        public static class JavaVM
        extends Structure {
            public volatile JNIInvokeInterface.ByReference functions;

            JavaVM() {
            }

            protected List<String> getFieldOrder() {
                return Arrays.asList("functions");
            }

            public static class ByReference
            extends JavaVM
            implements Structure.ByReference {
            }
        }
    }
}

