/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.swing;

import dorkbox.util.ActionHandlerLong;
import dorkbox.util.swing.ActiveRenderLoop;
import dorkbox.util.swing.SynchronizedEventQueue;
import java.awt.Component;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.SwingUtilities;

public final class SwingActiveRender {
    private static Thread activeRenderThread = null;
    static final List<Component> activeRenders = new ArrayList<Component>();
    static final List<ActionHandlerLong> activeRenderEvents = new CopyOnWriteArrayList<ActionHandlerLong>();
    static volatile boolean hasActiveRenders = false;
    private static final Runnable renderLoop = new ActiveRenderLoop();

    private SwingActiveRender() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addActiveRender(final Component component) {
        if (!EventQueue.isDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SwingActiveRender.addActiveRender(component);
                }
            });
            return;
        }
        component.setIgnoreRepaint(true);
        List<Component> list = activeRenders;
        synchronized (list) {
            if (!hasActiveRenders) {
                SwingActiveRender.setupActiveRenderThread();
            }
            hasActiveRenders = true;
            activeRenders.add(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeActiveRender(final Component component) {
        if (!EventQueue.isDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SwingActiveRender.removeActiveRender(component);
                }
            });
            return;
        }
        List<Component> list = activeRenders;
        synchronized (list) {
            boolean hadActiveRenders;
            activeRenders.remove(component);
            hasActiveRenders = hadActiveRenders = !activeRenders.isEmpty();
            if (!hadActiveRenders) {
                activeRenderThread = null;
            }
        }
        component.setIgnoreRepaint(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addActiveRenderFrameStart(ActionHandlerLong handler) {
        List<Component> list = activeRenders;
        synchronized (list) {
            activeRenderEvents.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsActiveRenderFrameStart(ActionHandlerLong handler) {
        List<Component> list = activeRenders;
        synchronized (list) {
            return activeRenderEvents.contains(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeActiveRenderFrameStart(ActionHandlerLong handler) {
        List<Component> list = activeRenders;
        synchronized (list) {
            activeRenderEvents.remove(handler);
        }
    }

    private static void setupActiveRenderThread() {
        if (activeRenderThread != null) {
            return;
        }
        SynchronizedEventQueue.install();
        activeRenderThread = new Thread(renderLoop, "AWT-ActiveRender");
        activeRenderThread.setDaemon(true);
        activeRenderThread.start();
    }
}

